/*
 * Decompiled with CFR 0.152.
 */
package icu.congee.id.generator.elasticflake;

import icu.congee.id.generator.elasticflake.Base64;
import icu.congee.id.generator.elasticflake.MacAddressProvider;
import icu.congee.id.generator.elasticflake.SecureRandomHolder;
import icu.congee.id.generator.elasticflake.UUIDGenerator;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;

public class TimeBasedUUIDGenerator
implements UUIDGenerator {
    private final AtomicInteger sequenceNumber = new AtomicInteger(SecureRandomHolder.INSTANCE.nextInt());
    private long lastTimestamp;
    private static final byte[] secureMungedAddress = MacAddressProvider.getSecureMungedAddress();

    static {
        assert (secureMungedAddress.length == 6);
    }

    private static void putLong(byte[] array, long l, int pos, int numberOfLongBytes) {
        int i = 0;
        while (i < numberOfLongBytes) {
            array[pos + numberOfLongBytes - i - 1] = (byte)(l >>> i * 8);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getBase64UUID() {
        byte[] encoded;
        int sequenceId = this.sequenceNumber.incrementAndGet() & 0xFFFFFF;
        long timestamp = System.currentTimeMillis();
        TimeBasedUUIDGenerator timeBasedUUIDGenerator = this;
        synchronized (timeBasedUUIDGenerator) {
            timestamp = Math.max(this.lastTimestamp, timestamp);
            if (sequenceId == 0) {
                ++timestamp;
            }
            this.lastTimestamp = timestamp;
        }
        byte[] uuidBytes = new byte[15];
        TimeBasedUUIDGenerator.putLong(uuidBytes, timestamp, 0, 6);
        System.arraycopy(secureMungedAddress, 0, uuidBytes, 6, secureMungedAddress.length);
        TimeBasedUUIDGenerator.putLong(uuidBytes, sequenceId, 12, 3);
        assert (9 + secureMungedAddress.length == uuidBytes.length);
        try {
            encoded = Base64.encodeBytesToBytes(uuidBytes, 0, uuidBytes.length, 16);
        }
        catch (IOException e) {
            throw new RuntimeException("should not be thrown", e);
        }
        assert (encoded[encoded.length - 1] != 61);
        return new String(encoded, 0, encoded.length, Base64.PREFERRED_ENCODING);
    }
}

