/*
 * Decompiled with CFR 0.152.
 */
package icu.congee.id.generator.pushid;

import icu.congee.id.base.IdGenerator;
import icu.congee.id.base.IdType;

public class PushIDGenerator
implements IdGenerator {
    private static final String PUSH_CHARS = "-0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ_abcdefghijklmnopqrstuvwxyz";
    private static long lastPushTime = 0L;
    private static int[] lastRandChars = new int[12];

    public static String generatePushID() {
        int i;
        long now = System.currentTimeMillis();
        boolean duplicateTime = now == lastPushTime;
        lastPushTime = now;
        char[] timeStampChars = new char[8];
        for (int i2 = 7; i2 >= 0; --i2) {
            timeStampChars[i2] = PUSH_CHARS.charAt((int)(now % 64L));
            now /= 64L;
        }
        if (now != 0L) {
            throw new RuntimeException("We should have converted the entire timestamp.");
        }
        StringBuilder id = new StringBuilder(new String(timeStampChars));
        if (!duplicateTime) {
            for (i = 0; i < 12; ++i) {
                PushIDGenerator.lastRandChars[i] = (int)(Math.random() * 64.0);
            }
        } else {
            for (i = 11; i >= 0 && lastRandChars[i] == 63; --i) {
                PushIDGenerator.lastRandChars[i] = 0;
            }
            int n = lastRandChars.length - 1;
            lastRandChars[n] = lastRandChars[n] + 1;
        }
        for (i = 0; i < 12; ++i) {
            id.append(PUSH_CHARS.charAt(lastRandChars[i]));
        }
        if (id.length() != 20) {
            throw new RuntimeException("Length should be 20.");
        }
        return id.toString();
    }

    public static void main(String[] args) {
        System.out.println(PushIDGenerator.generatePushID());
    }

    @Override
    public String generate() {
        return PushIDGenerator.generatePushID();
    }

    @Override
    public IdType idType() {
        return IdType.pushID;
    }
}

