/*
 * Decompiled with CFR 0.152.
 */
package icu.congee.id.generator.snowflake;

import icu.congee.id.base.IdGenerator;
import icu.congee.id.base.IdType;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicLong;

public class SnowflakeIdGenerator
implements IdGenerator {
    private static final long EPOCH = 1640995200000L;
    private static final int TIMESTAMP_BITS = 41;
    private static final int WORKER_ID_BITS = 10;
    private static final int SEQUENCE_BITS = 12;
    private static final long MAX_WORKER_ID = 1023L;
    private static final long MAX_SEQUENCE = 4095L;
    private static final long WORKER_ID_SHIFT = 12L;
    private static final long TIMESTAMP_SHIFT = 22L;
    private final long workerId;
    private final AtomicLong sequence;
    private long lastTimestamp;

    public SnowflakeIdGenerator(long workerId) {
        if (workerId > 1023L || workerId < 0L) {
            throw new IllegalArgumentException("Worker ID can't be greater than 1023 or less than 0");
        }
        this.workerId = workerId;
        this.sequence = new AtomicLong(0L);
        this.lastTimestamp = -1L;
    }

    public synchronized long next() {
        long timestamp = this.timeGen();
        if (timestamp < this.lastTimestamp) {
            throw new RuntimeException("Clock moved backwards. Refusing to generate id for " + (this.lastTimestamp - timestamp) + " milliseconds");
        }
        if (this.lastTimestamp == timestamp) {
            this.sequence.set(this.sequence.get() + 1L & 0xFFFL);
            if (this.sequence.get() == 0L) {
                timestamp = this.tilNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence.set(0L);
        }
        this.lastTimestamp = timestamp;
        return timestamp - 1640995200000L << 22 | this.workerId << 12 | this.sequence.get();
    }

    private long timeGen() {
        return Instant.now().toEpochMilli();
    }

    private long tilNextMillis(long lastTimestamp) {
        long timestamp = this.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = this.timeGen();
        }
        return timestamp;
    }

    @Override
    public Object generate() {
        return this.next();
    }

    @Override
    public IdType idType() {
        return IdType.Snowflake;
    }
}

