/*
 * Decompiled with CFR 0.152.
 */
package icu.congee.id.generator.uuid;

import icu.congee.id.base.IdGenerator;
import icu.congee.id.base.IdType;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;

public class UUIDv1Generator
implements IdGenerator {
    private static final long VERSION = 4096L;
    private static final long VARIANT = Long.MIN_VALUE;
    private static final long TIMESTAMP_MASK = 0xFFFFFFFFFFFFFFFL;
    private static final ThreadLocal<Short> sequence = ThreadLocal.withInitial(() -> (short)ThreadLocalRandom.current().nextInt(0, 16383));
    private static final long NODE_ID = ThreadLocalRandom.current().nextLong() & 0xFFFFFFFFFFFFL;

    public static UUID next() {
        long timestamp = System.currentTimeMillis() * 10000L + 122192928000000000L & 0xFFFFFFFFFFFFFFFL;
        long msb = timestamp << 4 | 0x1000L;
        long lsb = Long.MIN_VALUE | ((long)sequence.get().shortValue() & 0x3FFFL) << 48 | NODE_ID;
        return new UUID(msb, lsb);
    }

    @Override
    public String generate() {
        return UUIDv1Generator.next().toString();
    }

    @Override
    public IdType idType() {
        return IdType.UUIDv1;
    }
}

