/*
 * Decompiled with CFR 0.152.
 */
package icu.congee.id.generator.uuid;

import icu.congee.id.base.IdGenerator;
import icu.congee.id.base.IdType;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;

public class UUIDv6Generator
implements IdGenerator {
    private static final long GREGORIAN_TIMESTAMP_MASK = 0xFFFFFFFFFFFFFL;
    private static final long VERSION_IDENTIFIER = 24576L;
    private static final long VARIANT_IDENTIFIER = Long.MIN_VALUE;
    private static final long CLOCK_SEQUENCE_MASK = 16383L;
    private static final long NODE_ID_MASK = 0xFFFFFFFFFFFFL;
    private static final ThreadLocal<ThreadLocalSequence> threadLocalSequence = ThreadLocal.withInitial(() -> new ThreadLocalSequence());
    private static final long NODE_ID = ThreadLocalRandom.current().nextLong() & 0xFFFFFFFFFFFFL;

    public static UUID next() {
        ThreadLocalSequence seq = threadLocalSequence.get();
        long timestamp = System.currentTimeMillis() * 10000L + 122192928000000000L & 0xFFFFFFFFFFFFFL;
        long clockSequence = seq.sequence++ & 0x3FFFL;
        long msb = timestamp << 4 | 0x6000L;
        long lsb = Long.MIN_VALUE | clockSequence << 48 | NODE_ID;
        return new UUID(msb, lsb);
    }

    @Override
    public Object generate() {
        return UUIDv6Generator.next().toString();
    }

    @Override
    public IdType idType() {
        return IdType.UUIDv6;
    }

    private static class ThreadLocalSequence {
        long sequence = ThreadLocalRandom.current().nextLong() & 0x3FFFL;

        private ThreadLocalSequence() {
        }
    }
}

