# Flake ID生成器

## 简介
Flake ID是一种分布式ID生成算法，它是Snowflake算法的一个变种，专门针对分布式系统设计，提供了更好的性能和更大的序列号空间。

## ID结构
Flake ID生成的ID是一个64位的整数，由以下部分组成：

- 42位时间戳（精确到毫秒，以自定义纪元为基准）
- 10位生成器标识符
- 12位序列号

## 特点

1. **更大的序列号空间**
   - 序列号占12位，每毫秒最多生成4096个ID
   - 理论上单节点QPS可达4,096,000

2. **分布式友好**
   - 生成器标识符占10位，最多支持1024个节点
   - 支持数据中心和工作节点的组合标识
   - 无需中央节点分配和协调

3. **高性能**
   - 使用位运算进行ID组装
   - 内置序列号溢出处理机制
   - 支持时钟回拨检测

## 使用方法

```java
// 创建默认的Flake ID生成器实例
FlakeIdGenerator generator = new FlakeIdGenerator();

// 生成ID
Long id = generator.generate();
```

如果需要自定义配置：

```java
// 创建自定义配置
FlakeId.Options options = new FlakeId.Options();
// 设置数据中心ID（0-31）
options.datacenter = 1L;
// 设置工作节点ID（0-31）
options.worker = 1L;
// 设置起始时间戳（可选）
options.epoch = 1609459200000L; // 2021-01-01 00:00:00

// 使用自定义配置创建Flake ID实例
FlakeId flakeId = new FlakeId(options);

// 生成ID
byte[] id = flakeId.next();
```

## 注意事项

1. 生成器标识符的分配
   - 需要确保在分布式环境中，每个节点的生成器标识符是唯一的
   - 可以通过设置数据中心ID（5位）和工作节点ID（5位）的组合来实现
   - 也可以直接设置10位的生成器标识符

2. 时钟同步
   - 分布式系统中的各个节点需要进行时钟同步
   - 如果检测到时钟回拨，生成器会抛出异常
   - 建议使用NTP服务保持时钟同步

3. 序列号溢出处理
   - 当同一毫秒内序列号达到4095时，会等待下一毫秒
   - 内置自动等待机制，无需手动处理
   - 建议在高并发场景下进行性能测试

## 性能考虑

1. 单机性能
   - 每毫秒最多生成4096个ID
   - 理论最大QPS：4,096,000

2. 分布式性能
   - 最多支持1024个节点同时生成ID
   - 理论集群总QPS：4,194,304,000

## 应用场景

1. 分布式系统的主键生成
2. 分布式任务ID生成
3. 分布式消息ID生成
4. 需要按时间排序的场景

## 对比其他ID生成器

相比Snowflake：
- 序列号空间更大（4096个 vs 4096个）
- 节点标识更灵活（支持数据中心和工作节点组合）
- 性能相当

相比Sonyflake：
- 时间精度更高（1ms vs 10ms）
- 序列号空间更大（4096个 vs 256个）
- 单节点性能更好
- 支持的节点数较少（1024个 vs 65536个）