/*
 * Decompiled with CFR 0.152.
 */
package icu.congee.id.base;

import java.nio.ByteBuffer;

public class HexCodec {
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final int[] VALUES = new int[128];

    static {
        int i = 0;
        while (i < VALUES.length) {
            HexCodec.VALUES[i] = -1;
            ++i;
        }
        i = 0;
        while (i < DIGITS.length) {
            HexCodec.VALUES[HexCodec.DIGITS[i]] = i;
            if (i > 9) {
                HexCodec.VALUES[Character.toUpperCase((char)HexCodec.DIGITS[i])] = i;
            }
            ++i;
        }
    }

    public static String encode(long value) {
        if (value == 0L) {
            return "0";
        }
        StringBuilder sb = new StringBuilder();
        while (value != 0L) {
            sb.append(DIGITS[(int)(value & 0xFL)]);
            value >>>= 4;
        }
        return sb.reverse().toString();
    }

    public static String encode(byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        long value = buffer.getLong();
        return HexCodec.encode(value);
    }

    public static byte[] decode(String hex) {
        long value = HexCodec.decodeLong(hex);
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(value);
        return buffer.array();
    }

    private static long decodeLong(String hex) {
        if (hex == null || hex.isEmpty()) {
            throw new IllegalArgumentException("hex string cannot be null or empty");
        }
        long result = 0L;
        int i = 0;
        while (i < hex.length()) {
            char c = hex.charAt(i);
            if (c >= VALUES.length || VALUES[c] == -1) {
                throw new IllegalArgumentException("invalid hex character: " + c);
            }
            result = result << 4 | (long)VALUES[c];
            ++i;
        }
        return result;
    }
}

