/*
 * Decompiled with CFR 0.152.
 */
package icu.congee.id.generator.combguid;

import icu.congee.id.base.IdGenerator;
import icu.congee.id.base.IdType;
import java.time.Instant;
import java.util.UUID;

public class CombGuidGenerator
implements IdGenerator {
    public static UUID next() {
        UUID uuid = UUID.randomUUID();
        long timestamp = Instant.now().toEpochMilli();
        long msb = uuid.getMostSignificantBits();
        long lsb = uuid.getLeastSignificantBits();
        long newMsb = (timestamp & 0xFFFFFFFFFFFFL) << 16 | msb & 0xFFFFL;
        return new UUID(newMsb, lsb);
    }

    @Override
    public String generate() {
        return CombGuidGenerator.next().toString();
    }

    @Override
    public IdType idType() {
        return IdType.COMBGUID;
    }
}

