/*
 * Decompiled with CFR 0.152.
 */
package icu.congee.id.generator.cosid;

import icu.congee.id.base.Base62Codec;
import icu.congee.id.base.IdGenerator;
import icu.congee.id.base.IdType;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicLong;

public class CosIdGenerator
implements IdGenerator {
    private static final long EPOCH = 1609459200000L;
    private static final int MACHINE_BITS = 20;
    private static final int SEQUENCE_BITS = 16;
    private static final long MAX_SEQUENCE = 65535L;
    private static final long MACHINE_LEFT_SHIFT = 16L;
    private static final long TIMESTAMP_LEFT_SHIFT = 36L;
    private static final long machineId = (int)(Math.random() * 1048576.0);
    private static final AtomicLong sequence = new AtomicLong(0L);
    private static long lastTimestamp = -1L;

    public static synchronized String next() {
        long timestamp = CosIdGenerator.timeGen();
        if (timestamp < lastTimestamp) {
            throw new RuntimeException("Clock moved backwards. Refusing to generate id");
        }
        if (lastTimestamp == timestamp) {
            sequence.set(sequence.get() + 1L & 0xFFFFL);
            if (sequence.get() == 0L) {
                timestamp = CosIdGenerator.tilNextMillis(lastTimestamp);
            }
        } else {
            sequence.set(0L);
        }
        lastTimestamp = timestamp;
        byte[] result = new byte[10];
        long timestampPart = timestamp - 1609459200000L;
        int i = 0;
        while (i < 6) {
            result[i] = (byte)(timestampPart >> (5 - i) * 8);
            ++i;
        }
        long machinePart = machineId << 16;
        result[5] = (byte)(result[5] | (byte)(machinePart >> 16 & 0xFL));
        result[6] = (byte)(machinePart >> 8);
        result[7] = (byte)machinePart;
        long sequencePart = sequence.get();
        result[8] = (byte)(sequencePart >> 8);
        result[9] = (byte)sequencePart;
        return Base62Codec.encode(result);
    }

    private static long timeGen() {
        return Instant.now().toEpochMilli();
    }

    private static long tilNextMillis(long lastTimestamp) {
        long timestamp = CosIdGenerator.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = CosIdGenerator.timeGen();
        }
        return timestamp;
    }

    @Override
    public Object generate() {
        return CosIdGenerator.next();
    }

    @Override
    public IdType idType() {
        return IdType.CosId;
    }
}

