/*
 * Decompiled with CFR 0.152.
 */
package icu.congee.id.generator.custom;

import icu.congee.id.base.IdGenerator;
import icu.congee.id.base.IdType;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.atomic.AtomicInteger;

public class TimeBasedBusinessIdGenerator
implements IdGenerator {
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyMMddHHmmss").withZone(ZoneId.systemDefault());
    private static final int MAX_SEQUENCE = 9999;
    private static final AtomicInteger sequence = new AtomicInteger(0);
    private static volatile long lastTimestamp = -1L;

    public static synchronized Long next() {
        long currentTimestamp = System.currentTimeMillis();
        if (currentTimestamp < lastTimestamp) {
            currentTimestamp = lastTimestamp;
        }
        Instant instant = Instant.ofEpochMilli(currentTimestamp);
        String timestampStr = FORMATTER.format(instant);
        if (currentTimestamp / 1000L == lastTimestamp / 1000L) {
            int currentSequence = sequence.incrementAndGet();
            if (currentSequence > 9999) {
                while ((currentTimestamp = System.currentTimeMillis()) / 1000L == lastTimestamp / 1000L) {
                }
                sequence.set(0);
                lastTimestamp = currentTimestamp;
                instant = Instant.ofEpochMilli(currentTimestamp);
                timestampStr = FORMATTER.format(instant);
            }
        } else {
            sequence.set(0);
            lastTimestamp = currentTimestamp;
        }
        String sequenceStr = String.format("%04d", sequence.get());
        return Long.parseLong(String.valueOf(timestampStr) + sequenceStr);
    }

    @Override
    public Long generate() {
        return TimeBasedBusinessIdGenerator.next();
    }

    @Override
    public IdType idType() {
        return IdType.CustomTimeBasedBusinessId;
    }
}

