/*
 * Decompiled with CFR 0.152.
 */
package icu.congee.id.generator.js;

import icu.congee.id.base.IdGenerator;
import icu.congee.id.base.IdType;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLong;

public class JavaScriptSafetyIdGenerator
implements IdGenerator {
    private Random random = ThreadLocalRandom.current();
    private long epoch = 1645557742L;
    private static final AtomicLong atomicLong = new AtomicLong(System.currentTimeMillis() << 2);

    public JavaScriptSafetyIdGenerator() {
    }

    public JavaScriptSafetyIdGenerator(long epoch) {
        this.epoch = epoch;
    }

    public JavaScriptSafetyIdGenerator(Random random) {
        this.random = random;
    }

    public JavaScriptSafetyIdGenerator(Random random, long epoch) {
        this.random = random;
        this.epoch = epoch;
    }

    public static long next() {
        return JavaScriptSafetyIdGenerator.next(1)[0];
    }

    public static long monotonic() {
        return atomicLong.getAndIncrement();
    }

    public static long[] next(int count) {
        if (count <= 0) {
            throw new IllegalArgumentException("\u751f\u6210\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0");
        }
        if (count > 1024) {
            throw new IllegalArgumentException("\u751f\u6210\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc71024");
        }
        long[] ids = new long[count];
        ThreadLocalRandom random = ThreadLocalRandom.current();
        long currentTime = System.currentTimeMillis() - 1645557742L;
        long timestampPart = currentTime >> 4;
        timestampPart <<= 16;
        int i = 0;
        while (i < count) {
            int randomPart = random.nextInt() & 0xFFFF;
            ids[i] = timestampPart | (long)randomPart;
            ++i;
        }
        return ids;
    }

    @Override
    public Object generate() {
        long currentTime = System.currentTimeMillis() - this.epoch;
        long timestampPart = currentTime >> 4;
        int randomPart = this.random.nextInt() & 0xFFFF;
        return (timestampPart <<= 16) | (long)randomPart;
    }

    @Override
    public IdType idType() {
        return IdType.CustomJavaScriptSafetyId;
    }
}

