/*
 * Decompiled with CFR 0.152.
 */
package icu.congee.id.generator.ksuid;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.Arrays;
import java.util.SplittableRandom;

public final class Ksuid
implements Serializable,
Comparable<Ksuid> {
    private static final long serialVersionUID = 3045351825700035803L;
    private final int seconds;
    private final byte[] payload;
    public static final int KSUID_CHARS = 27;
    public static final int KSUID_BYTES = 20;
    public static final int TIME_BYTES = 4;
    public static final int PAYLOAD_BYTES = 16;
    public static final long EPOCH_OFFSET = 1400000000L;
    static final int BASE62_RADIX = 62;
    static final char[] BASE62_ALPHABET = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".toCharArray();
    static final byte[] BASE62_MAP = new byte[256];
    static final int KSUID_INTS = 5;
    static final long INTEGER_MASK = 0xFFFFFFFFL;

    static {
        Arrays.fill(BASE62_MAP, (byte)-1);
        int i = 0;
        while (i < BASE62_ALPHABET.length) {
            Ksuid.BASE62_MAP[Ksuid.BASE62_ALPHABET[i]] = (byte)i;
            ++i;
        }
    }

    public Ksuid(Ksuid ksuid) {
        this.seconds = ksuid.seconds;
        this.payload = new byte[16];
        System.arraycopy(ksuid.payload, 0, this.payload, 0, 16);
    }

    public Ksuid(long seconds, byte[] payload) {
        if (payload == null || payload.length != 16) {
            throw new IllegalArgumentException("Invalid payload length or null");
        }
        this.seconds = (int)Ksuid.toKsuidTime(seconds);
        this.payload = new byte[16];
        System.arraycopy(payload, 0, this.payload, 0, 16);
    }

    Ksuid(byte[] bytes) {
        if (bytes == null || bytes.length != 20) {
            throw new IllegalArgumentException("Invalid byte array length or null");
        }
        int secondz = 0;
        secondz |= (bytes[0] & 0xFF) << 24;
        secondz |= (bytes[1] & 0xFF) << 16;
        secondz |= (bytes[2] & 0xFF) << 8;
        this.seconds = secondz |= (bytes[3] & 0xFF) << 0;
        this.payload = new byte[16];
        System.arraycopy(bytes, 4, this.payload, 0, 16);
    }

    Ksuid(int[] ints) {
        if (ints == null || ints.length != 5) {
            throw new IllegalArgumentException("Invalid integer array length or null");
        }
        this.seconds = ints[0];
        this.payload = new byte[16];
        int i = 1;
        int j = 0;
        while (i < ints.length) {
            this.payload[j + 0] = (byte)(ints[i] >>> 24 & 0xFF);
            this.payload[j + 1] = (byte)(ints[i] >>> 16 & 0xFF);
            this.payload[j + 2] = (byte)(ints[i] >>> 8 & 0xFF);
            this.payload[j + 3] = (byte)(ints[i] >>> 0 & 0xFF);
            ++i;
            j += 4;
        }
    }

    public static Ksuid fast() {
        SplittableRandom random = new SplittableRandom();
        ByteBuffer buffer = ByteBuffer.allocate(16);
        long seconds = Instant.now().getEpochSecond();
        byte[] payload = buffer.putLong(random.nextLong()).putLong(random.nextLong()).array();
        return new Ksuid(seconds, payload);
    }

    public static Ksuid from(byte[] bytes) {
        return new Ksuid(bytes);
    }

    public static Ksuid from(String string) {
        return Ksuid.fromBase62(string);
    }

    public byte[] toBytes() {
        byte[] bytes = new byte[20];
        bytes[0] = (byte)(this.seconds >>> 24 & 0xFF);
        bytes[1] = (byte)(this.seconds >>> 16 & 0xFF);
        bytes[2] = (byte)(this.seconds >>> 8 & 0xFF);
        bytes[3] = (byte)(this.seconds >>> 0 & 0xFF);
        System.arraycopy(this.payload, 0, bytes, 4, 16);
        return bytes;
    }

    public String toString() {
        return Ksuid.toBase62(this);
    }

    public Instant getInstant() {
        return Instant.ofEpochSecond(this.getTime());
    }

    public static Instant getInstant(String string) {
        return Instant.ofEpochSecond(Ksuid.getTime(string));
    }

    public long getTime() {
        return Ksuid.toUnixTime(this.seconds);
    }

    public static long getTime(String string) {
        return Ksuid.from(string).getTime();
    }

    public byte[] getPayload() {
        byte[] copy = new byte[16];
        System.arraycopy(this.payload, 0, copy, 0, 16);
        return copy;
    }

    public static byte[] getPayload(String string) {
        return Ksuid.from(string).getPayload();
    }

    public static boolean isValid(String string) {
        return string != null && Ksuid.isValid(string.toCharArray());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.seconds;
        int i = 0;
        while (i < 16) {
            result = 31 * result + this.payload[i];
            ++i;
        }
        return result;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass() != Ksuid.class) {
            return false;
        }
        Ksuid that = (Ksuid)other;
        if (this.seconds != that.seconds) {
            return false;
        }
        int i = 0;
        while (i < 16) {
            if (this.payload[i] != that.payload[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public int compareTo(Ksuid that) {
        int min = Integer.MIN_VALUE;
        int a = this.seconds + Integer.MIN_VALUE;
        int b = that.seconds + Integer.MIN_VALUE;
        if (a > b) {
            return 1;
        }
        if (a < b) {
            return -1;
        }
        int i = 0;
        while (i < 16) {
            if ((this.payload[i] & 0xFF) > (that.payload[i] & 0xFF)) {
                return 1;
            }
            if ((this.payload[i] & 0xFF) < (that.payload[i] & 0xFF)) {
                return -1;
            }
            ++i;
        }
        return 0;
    }

    public Ksuid increment() {
        boolean overflow = false;
        Ksuid ksuid = new Ksuid(this);
        int i = 15;
        while (i >= 0) {
            int n = i;
            ksuid.payload[n] = (byte)(ksuid.payload[n] + 1);
            if (ksuid.payload[n] != 0) break;
            if (i == 0) {
                long time = ksuid.getTime() + 1L;
                ksuid = new Ksuid(time, ksuid.getPayload());
            }
            --i;
        }
        return ksuid;
    }

    static long toKsuidTime(long unixTime) {
        return unixTime - 1400000000L & 0xFFFFFFFFL;
    }

    static long toUnixTime(long ksuidTime) {
        return (ksuidTime & 0xFFFFFFFFL) + 1400000000L;
    }

    static String toBase62(Ksuid ksuid) {
        int[] number = ksuid.toInts();
        int b = 27;
        char[] buffer = new char[27];
        while (!Ksuid.isZero(number)) {
            int[] quotient = new int[5];
            int remainder = Ksuid.remainder(number, 62, quotient);
            buffer[--b] = BASE62_ALPHABET[remainder];
            number = quotient;
        }
        while (b > 0) {
            buffer[--b] = 48;
        }
        return new String(buffer);
    }

    static Ksuid fromBase62(String string) {
        char[] chars;
        int[] number = new int[5];
        char[] cArray = chars = Ksuid.toCharArray(string);
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            char aChar = cArray[n2];
            byte remainder = BASE62_MAP[aChar];
            number = Ksuid.multiply(number, 62, remainder, true);
            ++n2;
        }
        return new Ksuid(number);
    }

    static int remainder(int[] number, int divisor, int[] quotient) {
        long temporary = 0L;
        long remainder = 0L;
        int i = 0;
        while (i < number.length) {
            temporary = remainder << 32 | (long)number[i] & 0xFFFFFFFFL;
            quotient[i] = (int)(temporary / (long)divisor);
            remainder = temporary % (long)divisor;
            ++i;
        }
        return (int)remainder;
    }

    static int[] multiply(int[] number, int multiplier, int addend, boolean validate) {
        long temporary = 0L;
        long overflow = addend;
        int[] product = new int[5];
        int i = 4;
        while (i >= 0) {
            temporary = ((long)number[i] & 0xFFFFFFFFL) * (long)multiplier + overflow;
            product[i] = (int)temporary;
            overflow = temporary >>> 32;
            --i;
        }
        if (validate && overflow != 0L) {
            throw new IllegalArgumentException("Invalid KSUID (overflow)");
        }
        return product;
    }

    int[] toInts() {
        int[] ints = new int[5];
        ints[0] = this.seconds;
        int i = 1;
        int j = 0;
        while (i < ints.length) {
            int n = i;
            ints[n] = ints[n] | (this.payload[j + 0] & 0xFF) << 24;
            int n2 = i;
            ints[n2] = ints[n2] | (this.payload[j + 1] & 0xFF) << 16;
            int n3 = i;
            ints[n3] = ints[n3] | (this.payload[j + 2] & 0xFF) << 8;
            int n4 = i++;
            ints[n4] = ints[n4] | (this.payload[j + 3] & 0xFF) << 0;
            j += 4;
        }
        return ints;
    }

    private static boolean isZero(int[] number) {
        return number[0] == 0 && number[1] == 0 && number[2] == 0 && number[3] == 0 && number[4] == 0;
    }

    private static char[] toCharArray(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Invalid KSUID: null");
        }
        char[] chars = string.toCharArray();
        if (!Ksuid.isValid(chars)) {
            throw new IllegalArgumentException(String.format("Invalid KSUID: \"%s\"", string));
        }
        return chars;
    }

    private static boolean isValid(char[] chars) {
        if (chars == null || chars.length != 27) {
            return false;
        }
        char[] cArray = chars;
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            char aChar = cArray[n2];
            if (BASE62_MAP[aChar] == -1) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

