/*
 * Decompiled with CFR 0.152.
 */
package icu.congee.id.generator.pushid;

import icu.congee.id.base.IdGenerator;
import icu.congee.id.base.IdType;

public class PushIDGenerator
implements IdGenerator {
    private static final String PUSH_CHARS = "-0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ_abcdefghijklmnopqrstuvwxyz";
    private static long lastPushTime = 0L;
    private static int[] lastRandChars = new int[12];

    public static String generatePushID() {
        int i;
        long now = System.currentTimeMillis();
        boolean duplicateTime = now == lastPushTime;
        lastPushTime = now;
        char[] timeStampChars = new char[8];
        int i2 = 7;
        while (i2 >= 0) {
            timeStampChars[i2] = PUSH_CHARS.charAt((int)(now % 64L));
            now /= 64L;
            --i2;
        }
        if (now != 0L) {
            throw new RuntimeException("We should have converted the entire timestamp.");
        }
        StringBuilder id = new StringBuilder(new String(timeStampChars));
        if (!duplicateTime) {
            i = 0;
            while (i < 12) {
                PushIDGenerator.lastRandChars[i] = (int)(Math.random() * 64.0);
                ++i;
            }
        } else {
            i = 11;
            while (i >= 0 && lastRandChars[i] == 63) {
                PushIDGenerator.lastRandChars[i] = 0;
                --i;
            }
            int n = lastRandChars.length - 1;
            lastRandChars[n] = lastRandChars[n] + 1;
        }
        i = 0;
        while (i < 12) {
            id.append(PUSH_CHARS.charAt(lastRandChars[i]));
            ++i;
        }
        if (id.length() != 20) {
            throw new RuntimeException("Length should be 20.");
        }
        return id.toString();
    }

    public static void main(String[] args) {
        System.out.println(PushIDGenerator.generatePushID());
    }

    @Override
    public String generate() {
        return PushIDGenerator.generatePushID();
    }

    @Override
    public IdType idType() {
        return IdType.pushID;
    }
}

