/*
 * Decompiled with CFR 0.152.
 */
package icu.congee.id.generator.uuid;

import icu.congee.id.base.IdGenerator;
import icu.congee.id.base.IdType;
import java.net.NetworkInterface;
import java.security.SecureRandom;
import java.time.Instant;
import java.util.UUID;

public class UUIDv1Generator
implements IdGenerator {
    private static final long START_EPOCH_SECONDS = -12219292800L;
    private static final int NANOS_PER_100NS = 100;
    private static volatile long lastTimestamp = 0L;
    private static final SecureRandom SECURE_RANDOM = new SecureRandom();
    private static volatile int clockSequence = SECURE_RANDOM.nextInt() & 0x3FFF;
    private static final long NODE_ID = UUIDv1Generator.initializeNodeId();

    public static synchronized UUID next() {
        long timestamp = UUIDv1Generator.getPreciseTimestamp();
        int sequence = UUIDv1Generator.updateClockSequence(timestamp);
        return UUIDv1Generator.constructUUID(timestamp, sequence, NODE_ID);
    }

    private static long getPreciseTimestamp() {
        Instant now = Instant.now();
        long seconds = now.getEpochSecond() - -12219292800L;
        int nanos = now.getNano();
        return seconds * 10000000L + (long)(nanos / 100);
    }

    private static synchronized int updateClockSequence(long currentTimestamp) {
        if (currentTimestamp > lastTimestamp) {
            lastTimestamp = currentTimestamp;
            return clockSequence;
        }
        if (currentTimestamp < lastTimestamp) {
            clockSequence = SECURE_RANDOM.nextInt() & 0x3FFF;
            return clockSequence;
        }
        clockSequence = clockSequence + 1 & 0x3FFF;
        return clockSequence;
    }

    private static long initializeNodeId() {
        byte[] nodeBytes = new byte[6];
        try {
            byte[] mac;
            NetworkInterface network = NetworkInterface.getNetworkInterfaces().nextElement();
            if (network != null && (mac = network.getHardwareAddress()) != null && mac.length >= 6) {
                System.arraycopy(mac, 0, nodeBytes, 0, 6);
                nodeBytes[0] = (byte)(nodeBytes[0] | 1);
                return UUIDv1Generator.bytesToLong(nodeBytes);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        new SecureRandom().nextBytes(nodeBytes);
        nodeBytes[0] = (byte)(nodeBytes[0] | 1);
        return UUIDv1Generator.bytesToLong(nodeBytes);
    }

    private static long bytesToLong(byte[] bytes) {
        if (bytes.length != 6) {
            throw new IllegalArgumentException("\u9700\u89816\u5b57\u8282\u6570\u7ec4");
        }
        return ((long)bytes[0] & 0xFFL) << 40 | ((long)bytes[1] & 0xFFL) << 32 | ((long)bytes[2] & 0xFFL) << 24 | ((long)bytes[3] & 0xFFL) << 16 | ((long)bytes[4] & 0xFFL) << 8 | (long)bytes[5] & 0xFFL;
    }

    private static UUID constructUUID(long timestamp, int clockSeq, long nodeId) {
        long timeLow = timestamp & 0xFFFFFFFFL;
        long timeMid = timestamp >>> 32 & 0xFFFFL;
        long timeHigh = timestamp >>> 48 & 0xFFFL;
        long msb = timeLow << 32 | timeMid << 16 | (timeHigh | 0x1000L);
        long lsb = (0x8000L | (long)clockSeq & 0x3FFFL) << 48 | nodeId & 0xFFFFFFFFFFFFL;
        return new UUID(msb, lsb);
    }

    @Override
    public String generate() {
        return UUIDv1Generator.next().toString();
    }

    @Override
    public IdType idType() {
        return IdType.UUIDv1;
    }
}

