/*
 * Decompiled with CFR 0.152.
 */
package icu.congee.id.generator.uuid;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;

public class UUIDv5Generator {
    private static final int VERSION_IDENTIFIER = 5;
    private static final long VARIANT_IDENTIFIER = Long.MIN_VALUE;
    public static final UUID NAMESPACE_DNS = UUID.fromString("6ba7b810-9dad-11d1-80b4-00c04fd430c8");
    public static final UUID NAMESPACE_URL = UUID.fromString("6ba7b811-9dad-11d1-80b4-00c04fd430c8");
    public static final UUID NAMESPACE_OID = UUID.fromString("6ba7b812-9dad-11d1-80b4-00c04fd430c8");
    public static final UUID NAMESPACE_X500 = UUID.fromString("6ba7b814-9dad-11d1-80b4-00c04fd430c8");

    public static UUID fromNamespaceAndName(UUID namespace, String name) {
        try {
            MessageDigest sha1Digest = MessageDigest.getInstance("SHA-1");
            sha1Digest.update(UUIDv5Generator.uuidToBytes(namespace));
            sha1Digest.update(name.getBytes(StandardCharsets.UTF_8));
            byte[] hash = sha1Digest.digest();
            hash[6] = (byte)(hash[6] & 0xF);
            hash[6] = (byte)(hash[6] | 0x50);
            hash[8] = (byte)(hash[8] & 0x3F);
            hash[8] = (byte)(hash[8] | 0x80);
            long msb = 0L;
            long lsb = 0L;
            int i = 0;
            while (i < 8) {
                msb = msb << 8 | (long)(hash[i] & 0xFF);
                ++i;
            }
            i = 8;
            while (i < 16) {
                lsb = lsb << 8 | (long)(hash[i] & 0xFF);
                ++i;
            }
            return new UUID(msb, lsb);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("SHA-1\u7b97\u6cd5\u4e0d\u53ef\u7528", e);
        }
    }

    public static UUID fromDNS(String name) {
        return UUIDv5Generator.fromNamespaceAndName(NAMESPACE_DNS, name);
    }

    public static UUID fromURL(String name) {
        return UUIDv5Generator.fromNamespaceAndName(NAMESPACE_URL, name);
    }

    public static UUID fromOID(String name) {
        return UUIDv5Generator.fromNamespaceAndName(NAMESPACE_OID, name);
    }

    public static UUID fromX500(String name) {
        return UUIDv5Generator.fromNamespaceAndName(NAMESPACE_X500, name);
    }

    private static byte[] uuidToBytes(UUID uuid) {
        byte[] bytes = new byte[16];
        long msb = uuid.getMostSignificantBits();
        long lsb = uuid.getLeastSignificantBits();
        int i = 7;
        while (i >= 0) {
            bytes[i] = (byte)(msb & 0xFFL);
            msb >>>= 8;
            --i;
        }
        i = 15;
        while (i >= 8) {
            bytes[i] = (byte)(lsb & 0xFFL);
            lsb >>>= 8;
            --i;
        }
        return bytes;
    }
}

