/*
 * Decompiled with CFR 0.152.
 */
package icu.congee.id.base;

import java.nio.ByteBuffer;
import java.util.Arrays;

public class Base36Codec {
    private static final String BASE36_ALPHABET = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";

    public static String encode(byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        long number = buffer.getLong();
        if (number == 0L) {
            return "0";
        }
        StringBuilder sb = new StringBuilder();
        while (number > 0L) {
            int remainder = (int)(number % 36L);
            sb.insert(0, BASE36_ALPHABET.charAt(remainder));
            number /= 36L;
        }
        return sb.toString();
    }

    public static byte[] decode(String base36) {
        long result = 0L;
        base36 = base36.toUpperCase();
        for (int i = 0; i < base36.length(); ++i) {
            char c = base36.charAt(i);
            int digit = BASE36_ALPHABET.indexOf(c);
            result = result * 36L + (long)digit;
        }
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(result);
        return buffer.array();
    }

    public static void main(String[] args) {
        byte[] inputBytes = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        String encoded = Base36Codec.encode(inputBytes);
        byte[] decoded = Base36Codec.decode(encoded);
        System.out.println("Base36 \u7f16\u7801\u524d\u7684\u5b57\u8282\u6570\u7ec4: " + Arrays.toString(inputBytes));
        System.out.println("Base36 \u7f16\u7801\u540e\u7684\u5b57\u7b26\u4e32: " + encoded);
        System.out.println("Base36 \u89e3\u7801\u540e\u7684\u5b57\u8282\u6570\u7ec4: " + Arrays.toString(decoded));
    }
}

