/*
 * Decompiled with CFR 0.152.
 */
package icu.congee.id.base;

import java.nio.ByteBuffer;
import java.util.Arrays;

public class Base62Codec {
    private static final String BASE62_ALPHABET = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";

    public static String encode(byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        long number = buffer.getLong();
        if (number == 0L) {
            return "0";
        }
        StringBuilder sb = new StringBuilder();
        while (number > 0L) {
            int remainder = (int)(number % 62L);
            sb.insert(0, BASE62_ALPHABET.charAt(remainder));
            number /= 62L;
        }
        return sb.toString();
    }

    public static byte[] decode(String base62) {
        long result = 0L;
        for (int i = 0; i < base62.length(); ++i) {
            char c = base62.charAt(i);
            int digit = BASE62_ALPHABET.indexOf(c);
            result = result * 62L + (long)digit;
        }
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(result);
        return buffer.array();
    }

    public static void main(String[] args) {
        byte[] inputBytes = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        String encoded = Base62Codec.encode(inputBytes);
        byte[] decoded = Base62Codec.decode(encoded);
        System.out.println("Base62 \u7f16\u7801\u524d\u7684\u5b57\u8282\u6570\u7ec4: " + Arrays.toString(inputBytes));
        System.out.println("Base62 \u7f16\u7801\u540e\u7684\u5b57\u7b26\u4e32: " + encoded);
        System.out.println("Base62 \u89e3\u7801\u540e\u7684\u5b57\u8282\u6570\u7ec4: " + Arrays.toString(decoded));
    }
}

