/*
 * Decompiled with CFR 0.152.
 */
package icu.congee.id.base;

import java.nio.ByteBuffer;

public class HexCodec {
    private static final char[] DIGITS;
    private static final int[] VALUES;

    public static String encode(long value) {
        if (value == 0L) {
            return "0";
        }
        StringBuilder sb = new StringBuilder();
        while (value != 0L) {
            sb.append(DIGITS[(int)(value & 0xFL)]);
            value >>>= 4;
        }
        return sb.reverse().toString();
    }

    public static String encode(byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        long value = buffer.getLong();
        return HexCodec.encode(value);
    }

    public static byte[] decode(String hex) {
        long value = HexCodec.decodeLong(hex);
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(value);
        return buffer.array();
    }

    private static long decodeLong(String hex) {
        if (hex == null || hex.isEmpty()) {
            throw new IllegalArgumentException("hex string cannot be null or empty");
        }
        long result = 0L;
        for (int i = 0; i < hex.length(); ++i) {
            char c = hex.charAt(i);
            if (c >= VALUES.length || VALUES[c] == -1) {
                throw new IllegalArgumentException("invalid hex character: " + c);
            }
            result = result << 4 | (long)VALUES[c];
        }
        return result;
    }

    static {
        int i;
        DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        VALUES = new int[128];
        for (i = 0; i < VALUES.length; ++i) {
            HexCodec.VALUES[i] = -1;
        }
        for (i = 0; i < DIGITS.length; ++i) {
            HexCodec.VALUES[HexCodec.DIGITS[i]] = i;
            if (i <= 9) continue;
            HexCodec.VALUES[Character.toUpperCase((char)HexCodec.DIGITS[i])] = i;
        }
    }
}

