/*
 * Decompiled with CFR 0.152.
 */
package icu.congee.id.generator.broid;

import java.util.ArrayList;
import java.util.List;

public class BitUtils {
    public static List<Boolean> longToList(long value, int bits) {
        if (bits < 0 || bits > 64) {
            throw new IllegalArgumentException("bits \u5fc5\u987b\u5728 0 \u5230 64 \u4e4b\u95f4");
        }
        ArrayList<Boolean> booleanList = new ArrayList<Boolean>(bits);
        for (int i = bits - 1; i >= 0; --i) {
            boolean isSet = (value >> i & 1L) == 1L;
            booleanList.add(isSet);
        }
        return booleanList;
    }

    public static byte[] listToByteArray(List<Boolean> booleanList) {
        int size = booleanList.size();
        int byteSize = (size + 7) / 8;
        byte[] bytes = new byte[byteSize];
        for (int i = 0; i < size; ++i) {
            if (!booleanList.get(i).booleanValue()) continue;
            int n = i / 8;
            bytes[n] = (byte)(bytes[n] | (byte)(1 << 7 - i % 8));
        }
        return bytes;
    }

    public static long listToLong(List<Boolean> booleanList) {
        long result = 0L;
        int size = Math.min(booleanList.size(), 64);
        for (int i = 0; i < size; ++i) {
            if (!booleanList.get(i).booleanValue()) continue;
            result |= 1L << size - 1 - i;
        }
        return result;
    }
}

