/*
 * Decompiled with CFR 0.152.
 */
package icu.congee.id.generator.sid;

import icu.congee.id.base.IdGenerator;
import icu.congee.id.base.IdType;
import icu.congee.id.base.TimeUtils;
import java.util.Base64;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;

public class SIDGenerator
implements IdGenerator {
    private static final Random random = ThreadLocalRandom.current();

    private static byte[] longToBytes(long value) {
        byte[] bytes = new byte[]{(byte)(value >>> 56), (byte)(value >>> 48), (byte)(value >>> 40), (byte)(value >>> 32), (byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
        return bytes;
    }

    @Override
    public Object generate() {
        byte[] timestamp = SIDGenerator.longToBytes(TimeUtils.getCurrentUnixNano());
        byte[] randomNum = SIDGenerator.longToBytes(random.nextLong());
        return Base64.getEncoder().encodeToString(timestamp) + "-" + Base64.getEncoder().encodeToString(randomNum);
    }

    @Override
    public IdType idType() {
        return IdType.SID;
    }
}

