/*
 * Decompiled with CFR 0.152.
 */
package icu.congee.id.generator.uuid;

import icu.congee.id.base.IdGenerator;
import icu.congee.id.base.IdType;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;

public class UUIDv2Generator
implements IdGenerator {
    private static final long TIMESTAMP_EPOCH_OFFSET = 122192928000000000L;
    private static final AtomicLong timestampCounter = new AtomicLong();
    private static final byte securityDomain = 0;

    public static UUID next() {
        long timestamp = System.currentTimeMillis() * 10000L + 122192928000000000L & 0xFFFFFFFL;
        long sequence = timestampCounter.updateAndGet(prev -> timestamp > prev ? timestamp : prev + 1L);
        long msb = (sequence & 0xFFFFFFFL) << 36 | 0x2000L | ((long)UUIDv2Generator.getPOSIXUserId() & 0xFFFFL) << 20;
        long lsb = Long.MIN_VALUE | ((long)UUIDv2Generator.getPOSIXGroupId() & 0xFFFFFFFFL) << 16 | sequence & 0xFFFL;
        return new UUID(msb, lsb);
    }

    private static short getPOSIXUserId() {
        return 0;
    }

    private static int getPOSIXGroupId() {
        return 0;
    }

    @Override
    public Object generate() {
        return UUIDv2Generator.next().toString();
    }

    @Override
    public IdType idType() {
        return IdType.UUIDv2;
    }
}

