/*
 * Decompiled with CFR 0.152.
 */
package icu.congee.id.generator.uuid;

import icu.congee.id.base.IdGenerator;
import icu.congee.id.base.IdType;
import java.net.NetworkInterface;
import java.security.SecureRandom;
import java.time.Instant;
import java.util.Enumeration;
import java.util.UUID;

public class UUIDv6Generator
implements IdGenerator {
    private static final long GREGORIAN_OFFSET = 122192928000000000L;
    private static final SecureRandom random = new SecureRandom();
    private static long lastTimestamp = 0L;
    private static int lastClockSeq = -1;

    public static synchronized UUID next() {
        int clockSeq;
        long timestamp = UUIDv6Generator.getCurrentTimestamp();
        if (timestamp < lastTimestamp) {
            timestamp = lastTimestamp + 1L;
        }
        lastTimestamp = timestamp;
        long timeHigh = timestamp >>> 28 & 0xFFFFFFFFL;
        long timeMid = timestamp >>> 12 & 0xFFFFL;
        long timeLow = timestamp & 0xFFFL;
        int version = 6;
        int variant = 2;
        if (timestamp == lastTimestamp) {
            clockSeq = lastClockSeq + 1 & 0x3FFF;
            if (clockSeq == 0) {
                timestamp = UUIDv6Generator.tilNextMillis(lastTimestamp);
                clockSeq = random.nextInt() & 0x3FFF;
            }
        } else {
            clockSeq = random.nextInt() & 0x3FFF;
        }
        lastClockSeq = clockSeq;
        long randomNodeId = random.nextLong() & 0xFFFFFFFFFFFFL;
        long msb = timeHigh << 32 | timeMid << 16 | (long)(version << 12) | timeLow;
        long lsb = (long)variant << 62 | (long)clockSeq << 48 | randomNodeId;
        return new UUID(msb, lsb);
    }

    private static long getCurrentTimestamp() {
        Instant now = Instant.now();
        long seconds = now.getEpochSecond();
        int nanos = now.getNano();
        long total_100ns = seconds * 10000000L + (long)(nanos / 100);
        return total_100ns + 122192928000000000L;
    }

    private static long getNodeId() {
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface nic = interfaces.nextElement();
                byte[] mac = nic.getHardwareAddress();
                if (mac == null || mac.length != 6) continue;
                long node = 0L;
                for (byte b : mac) {
                    node = node << 8 | (long)(b & 0xFF);
                }
                return node;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return random.nextLong() & 0xFFFFFFFFFFFFL;
    }

    private static long tilNextMillis(long lastTimestamp) {
        long timestamp = UUIDv6Generator.getCurrentTimestamp();
        while (timestamp <= lastTimestamp) {
            timestamp = UUIDv6Generator.getCurrentTimestamp();
        }
        return timestamp;
    }

    @Override
    public Object generate() {
        return UUIDv6Generator.next().toString();
    }

    @Override
    public IdType idType() {
        return IdType.UUIDv6;
    }
}

