/*
 * Decompiled with CFR 0.152.
 */
package icu.congee.id.generator.wxseq;

import icu.congee.id.base.IdGenerator;
import icu.congee.id.base.IdType;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class WxSeqGenerator
implements IdGenerator {
    private static final ConcurrentHashMap<Long, AtomicLong> STORE_SVR = new ConcurrentHashMap();
    private static final int STEP = 10000;
    private static final ThreadLocal<Long> CURRENT_UID = new ThreadLocal();

    @Override
    public Object generate() {
        Long uid = CURRENT_UID.get();
        if (uid == null) {
            throw new IllegalStateException("Current uid not set");
        }
        AtomicLong maxSeqRef = STORE_SVR.computeIfAbsent(uid, k -> new AtomicLong(0L));
        long curSeq = maxSeqRef.get();
        if (curSeq % 10000L == 0L) {
            long newMaxSeq = curSeq + 10000L;
            maxSeqRef.set(newMaxSeq);
            System.out.println("Persist max_seq for uid " + uid + ": " + newMaxSeq);
        }
        long sequence = curSeq + 1L;
        maxSeqRef.incrementAndGet();
        return sequence;
    }

    @Override
    public IdType idType() {
        return IdType.WxSeq;
    }

    public static void setCurrentUid(Long uid) {
        CURRENT_UID.set(uid);
    }

    public static void clearCurrentUid() {
        CURRENT_UID.remove();
    }
}

