# SID 生成器

## 简介

SID（Sortable Identifier）是一个简单高效的可排序 ID 生成器。它基于时间戳和随机数组合生成唯一标识符，特别适用于需要按时间排序的分布式系统。

## ID 结构

SID 生成的 ID 由两部分组成：

- 时间戳：精确到毫秒的时间信息
- 随机数：确保同一时间戳下的唯一性

示例：`1701234567890-abc123`

## 特性

### 1. 可排序性

- 使用时间戳作为前缀，天然支持时间排序
- 适用于需要按时间检索的业务场景
- 支持范围查询和时间段筛选

### 2. 唯一性

- 时间戳和随机数的组合保证全局唯一
- 使用连字符（-）分隔，避免歧义
- 在高并发场景下依然保持唯一性

### 3. 简单可靠

- 无需外部依赖，实现简单
- 无状态设计，易于分布式部署
- 生成过程高效，性能优异

## 应用场景

1. **日志系统**

   - 记录按时间排序的日志事件
   - 快速定位特定时间段的日志

2. **订单系统**

   - 生成可排序的订单编号
   - 便于订单的时间管理和追踪

3. **消息系统**
   - 为消息分配唯一标识
   - 支持消息的时序处理

## 性能考虑

- 无锁设计，避免了同步开销
- 本地生成，无网络延迟
- 适合高并发场景

## 对比其他 ID 生成器

| 特性 | SID | UUID | 自增 ID | Snowflake |
|------|-----|------|--------|-----------||
| 可排序 | ✓ | × | ✓ | ✓ |
| 分布式友好 | ✓ | ✓ | × | ✓ |
| 实现复杂度 | 低 | 低 | 低 | 中 |
| 性能 | 高 | 高 | 高 | 高 |
| 依赖要求 | 无 | 无 | 数据库 | 时钟同步 |

## 参考

"sid : generate sortable identifiers", Commit 660e947, June 2019, https://github.com/chilts/sid
