/*
 * Decompiled with CFR 0.152.
 */
package icu.congee.id.base;

import java.util.HashMap;
import java.util.Map;

public class CrockfordBase32 {
    private static final String ALPHABET = "0123456789ABCDEFGHJKMNPQRSTVWXYZ";
    private static final int BASE = 32;
    private static final Map<Character, Integer> DECODING_MAP = new HashMap<Character, Integer>();

    static {
        int i = 0;
        while (i < ALPHABET.length()) {
            char c = ALPHABET.charAt(i);
            DECODING_MAP.put(Character.valueOf(c), i);
            DECODING_MAP.put(Character.valueOf(Character.toLowerCase(c)), i);
            ++i;
        }
        DECODING_MAP.put(Character.valueOf('I'), 1);
        DECODING_MAP.put(Character.valueOf('i'), 1);
        DECODING_MAP.put(Character.valueOf('L'), 1);
        DECODING_MAP.put(Character.valueOf('l'), 1);
        DECODING_MAP.put(Character.valueOf('O'), 0);
        DECODING_MAP.put(Character.valueOf('o'), 0);
    }

    public static String encode(byte[] data) {
        if (data == null || data.length == 0) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        int buffer = 0;
        int bitsLeft = 0;
        byte[] byArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            buffer = buffer << 8 | b & 0xFF;
            bitsLeft += 8;
            while (bitsLeft >= 5) {
                result.append(ALPHABET.charAt(buffer >> bitsLeft - 5 & 0x1F));
                bitsLeft -= 5;
            }
            ++n2;
        }
        if (bitsLeft > 0) {
            result.append(ALPHABET.charAt((buffer <<= 5 - bitsLeft) & 0x1F));
        }
        return result.toString();
    }

    public static byte[] decode(String encoded) {
        if (encoded == null || encoded.length() == 0) {
            return new byte[0];
        }
        encoded = encoded.replace("-", "");
        int bitLength = encoded.length() * 5;
        int byteLength = (bitLength + 7) / 8;
        byte[] result = new byte[byteLength];
        int buffer = 0;
        int bitsLeft = 0;
        int index = 0;
        char[] cArray = encoded.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (!DECODING_MAP.containsKey(Character.valueOf(c))) {
                throw new IllegalArgumentException("Invalid character in Base32 string: " + c);
            }
            buffer = buffer << 5 | DECODING_MAP.get(Character.valueOf(c));
            if ((bitsLeft += 5) >= 8) {
                result[index++] = (byte)(buffer >> bitsLeft - 8 & 0xFF);
                bitsLeft -= 8;
            }
            ++n2;
        }
        return result;
    }

    public static void main(String[] args) {
        byte[] originalData = "Hello, World!".getBytes();
        String encoded = CrockfordBase32.encode(originalData);
        byte[] decoded = CrockfordBase32.decode(encoded);
        System.out.println("Original data: " + new String(originalData));
        System.out.println("Encoded data: " + encoded);
        System.out.println("Decoded data: " + new String(decoded));
    }
}

