/*
 * Decompiled with CFR 0.152.
 */
package icu.congee.id.base;

import icu.congee.id.base.Base32Codec;
import icu.congee.id.base.Base36Codec;
import icu.congee.id.base.Base62Codec;
import icu.congee.id.base.CrockfordBase32;
import icu.congee.id.base.HexCodec;
import java.util.Base64;

public interface Id {
    public byte[] toBytes();

    public long toLong();

    public String toString();

    default public byte[] long2bytes(long value) {
        byte[] result = new byte[8];
        int i = 7;
        while (i >= 0) {
            result[i] = (byte)(value & 0xFFL);
            value >>= 8;
            --i;
        }
        return result;
    }

    default public String toBase64() {
        return Base64.getUrlEncoder().encodeToString(this.toBytes());
    }

    default public String toBase62() {
        return Base62Codec.encode(this.toBytes());
    }

    default public String toBase36() {
        return Base36Codec.encode(this.toBytes());
    }

    default public String toBase32() {
        return Base32Codec.encode(this.toBytes());
    }

    default public String toCrockfordBase32() {
        return CrockfordBase32.encode(this.toBytes());
    }

    default public String toHexString() {
        return HexCodec.encode(this.toBytes());
    }
}

