/*
 * Decompiled with CFR 0.152.
 */
package icu.congee.id.generator.broid;

import java.util.ArrayList;
import java.util.List;

public class BitUtils {
    public static List<Boolean> longToList(long value, int bits) {
        if (bits < 0 || bits > 64) {
            throw new IllegalArgumentException("bits \u5fc5\u987b\u5728 0 \u5230 64 \u4e4b\u95f4");
        }
        ArrayList<Boolean> booleanList = new ArrayList<Boolean>(bits);
        int i = bits - 1;
        while (i >= 0) {
            boolean isSet = (value >> i & 1L) == 1L;
            booleanList.add(isSet);
            --i;
        }
        return booleanList;
    }

    public static byte[] listToByteArray(List<Boolean> booleanList) {
        int size = booleanList.size();
        int byteSize = (size + 7) / 8;
        byte[] bytes = new byte[byteSize];
        int i = 0;
        while (i < size) {
            if (booleanList.get(i).booleanValue()) {
                int n = i / 8;
                bytes[n] = (byte)(bytes[n] | (byte)(1 << 7 - i % 8));
            }
            ++i;
        }
        return bytes;
    }

    public static long listToLong(List<Boolean> booleanList) {
        long result = 0L;
        int size = Math.min(booleanList.size(), 64);
        int i = 0;
        while (i < size) {
            if (booleanList.get(i).booleanValue()) {
                result |= 1L << size - 1 - i;
            }
            ++i;
        }
        return result;
    }
}

