/*
 * Decompiled with CFR 0.152.
 */
package icu.congee.id.generator.broid;

import icu.congee.id.base.Base36Codec;
import icu.congee.id.base.Base62Codec;
import icu.congee.id.base.CrockfordBase32;
import icu.congee.id.base.HexCodec;
import icu.congee.id.base.IdType;
import icu.congee.id.generator.broid.BitUtils;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import lombok.Generated;

public class BroId
implements Comparable<BroId> {
    private final String name = "BroId";
    private final String desc = "Custom Id";
    private final List<Boolean> value;

    public String toString() {
        return this.toBase62String();
    }

    public String toBase62String() {
        return Base62Codec.encode(BitUtils.listToByteArray(this.value));
    }

    public String toBase36String() {
        return Base36Codec.encode(BitUtils.listToByteArray(this.value));
    }

    public String toCrockfordBase32String() {
        return CrockfordBase32.encode(BitUtils.listToByteArray(this.value));
    }

    public String toHexString() {
        return HexCodec.encode(BitUtils.listToByteArray(this.value));
    }

    public Long toLong() {
        return BitUtils.listToLong(this.value);
    }

    public UUID toUUID() {
        long msb = BitUtils.listToLong(this.value.subList(0, 64));
        long lsb = BitUtils.listToLong(this.value.subList(64, 128));
        return new UUID(msb, lsb);
    }

    public UUID toUUID(IdType idType) {
        if (idType == IdType.UUIDv8) {
            this.value.set(48, true);
            this.value.set(49, false);
            this.value.set(50, false);
            this.value.set(51, false);
            this.value.set(64, true);
            this.value.set(65, false);
            long msb = BitUtils.listToLong(this.value.subList(0, 64));
            long lsb = BitUtils.listToLong(this.value.subList(64, 128));
            return new UUID(msb, lsb);
        }
        return null;
    }

    @Override
    public int compareTo(BroId other) {
        if (other == null) {
            return 1;
        }
        if (this.value == null) {
            return other.value == null ? 0 : -1;
        }
        if (other.value == null) {
            return 1;
        }
        int sizeComparison = Integer.compare(this.value.size(), other.value.size());
        if (sizeComparison != 0) {
            return sizeComparison;
        }
        int i = 0;
        while (i < this.value.size()) {
            boolean bit2;
            boolean bit1 = this.value.get(i);
            if (bit1 != (bit2 = other.value.get(i).booleanValue())) {
                return bit1 ? 1 : -1;
            }
            ++i;
        }
        return 0;
    }

    public static Comparator<BroId> getComparator() {
        return Comparator.nullsFirst(Comparator.comparing(BroId::getValue, (list1, list2) -> {
            if (list1 == null && list2 == null) {
                return 0;
            }
            if (list1 == null) {
                return -1;
            }
            if (list2 == null) {
                return 1;
            }
            int sizeComparison = Integer.compare(list1.size(), list2.size());
            if (sizeComparison != 0) {
                return sizeComparison;
            }
            int i = 0;
            while (i < list1.size()) {
                boolean bit2;
                boolean bit1 = (Boolean)list1.get(i);
                if (bit1 != (bit2 = ((Boolean)list2.get(i)).booleanValue())) {
                    return bit1 ? 1 : -1;
                }
                ++i;
            }
            return 0;
        }));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BroId broId = (BroId)o;
        if (this.value == null) {
            return broId.value == null;
        }
        if (broId.value == null) {
            return false;
        }
        if (this.value.size() != broId.value.size()) {
            return false;
        }
        int i = 0;
        while (i < this.value.size()) {
            if (this.value.get(i) != broId.value.get(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.value.toArray());
    }

    @Generated
    public String getName() {
        return "BroId";
    }

    @Generated
    public String getDesc() {
        return "Custom Id";
    }

    @Generated
    public List<Boolean> getValue() {
        return this.value;
    }

    @Generated
    public BroId(List<Boolean> value) {
        this.value = value;
    }
}

