/*
 * Decompiled with CFR 0.152.
 */
package icu.congee.id.generator.broid;

import icu.congee.id.base.IdType;
import icu.congee.id.generator.broid.BitUtils;
import icu.congee.id.generator.broid.BroId;
import icu.congee.id.generator.broid.BroIdGenerator;
import icu.congee.id.generator.broid.BroIdLayout;
import icu.congee.id.generator.broid.BroIdPart;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLong;

public class BroIdExample {
    public static BroIdGenerator<BroId> createSnowflakeGenerator() {
        ArrayList<BroIdPart> parts = new ArrayList<BroIdPart>();
        parts.add(new BroIdPart(){

            @Override
            public int getBits() {
                return 41;
            }

            @Override
            public List<Boolean> next() {
                return BitUtils.longToList(System.currentTimeMillis(), this.getBits());
            }
        });
        parts.add(new BroIdPart(){

            @Override
            public int getBits() {
                return 5;
            }

            @Override
            public List<Boolean> next() {
                return BitUtils.longToList(0L, this.getBits());
            }
        });
        parts.add(new BroIdPart(){

            @Override
            public int getBits() {
                return 5;
            }

            @Override
            public List<Boolean> next() {
                return BitUtils.longToList(0L, this.getBits());
            }
        });
        parts.add(new BroIdPart(){
            private final AtomicLong atomicLong = new AtomicLong(0L);

            @Override
            public int getBits() {
                return 12;
            }

            @Override
            public List<Boolean> next() {
                return BitUtils.longToList(this.atomicLong.getAndIncrement(), this.getBits());
            }
        });
        BroIdLayout layout = new BroIdLayout(parts);
        return new BroIdGenerator<BroId>(layout, BroId::new);
    }

    public static BroIdGenerator<BroId> createUUIDv8Generator() {
        ArrayList<BroIdPart> parts = new ArrayList<BroIdPart>();
        parts.add(new BroIdPart(){

            @Override
            public int getBits() {
                return 64;
            }

            @Override
            public List<Boolean> next() {
                Instant instant = Instant.now();
                long ts = instant.getEpochSecond() * 1000000000L + (long)instant.getNano();
                return BitUtils.longToList(ts, this.getBits());
            }
        });
        parts.add(new BroIdPart(){

            @Override
            public int getBits() {
                return 64;
            }

            @Override
            public List<Boolean> next() {
                return BitUtils.longToList(ThreadLocalRandom.current().nextLong(), this.getBits());
            }
        });
        BroIdLayout layout = new BroIdLayout(parts);
        return new BroIdGenerator<BroId>(layout, BroId::new);
    }

    public static void main(String[] args) {
        BroIdGenerator<BroId> snowflakeGenerator = BroIdExample.createSnowflakeGenerator();
        int i = 0;
        while (i < 10) {
            System.out.println("BroId encode base62: " + snowflakeGenerator.next());
            System.out.println("BroId encode base62: " + snowflakeGenerator.next().toBase62String());
            System.out.println("BroId encode base36: " + snowflakeGenerator.next().toBase36String());
            System.out.println("BroId encode crock ford base32: " + snowflakeGenerator.next().toCrockfordBase32String());
            System.out.println("BroId encode hex: " + snowflakeGenerator.next().toHexString());
            System.out.println("BroId encode long: " + snowflakeGenerator.next().toLong());
            ++i;
        }
        BroIdGenerator<BroId> uuidGenerator = BroIdExample.createUUIDv8Generator();
        int i2 = 0;
        while (i2 < 10) {
            System.out.println("BroId encode base62: " + uuidGenerator.next());
            System.out.println("BroId encode base62: " + uuidGenerator.next().toBase62String());
            System.out.println("BroId encode base36: " + uuidGenerator.next().toBase36String());
            System.out.println("BroId encode crock ford base32: " + uuidGenerator.next().toCrockfordBase32String());
            System.out.println("BroId encode hex: " + uuidGenerator.next().toHexString());
            System.out.println("BroId encode uuid: " + uuidGenerator.next().toUUID());
            System.out.println("BroId encode uuid: " + uuidGenerator.next().toUUID(IdType.UUIDv8));
            ++i2;
        }
    }
}

