/*
 * Decompiled with CFR 0.152.
 */
package icu.congee.id.generator.broid.part;

import icu.congee.id.generator.broid.BitUtils;
import icu.congee.id.generator.broid.BroIdPart;
import java.time.Instant;
import java.util.List;
import java.util.concurrent.TimeUnit;
import lombok.Generated;

public class TimestampBroIdPart
implements BroIdPart {
    private final TimeUnit timeUnit;
    private final long epoch;
    private final int bits;

    @Override
    public List<Boolean> next() {
        long timestamp;
        Instant instant = Instant.now();
        switch (this.timeUnit) {
            case DAYS: {
                timestamp = instant.getEpochSecond() / 60L / 60L / 24L;
                break;
            }
            case HOURS: {
                timestamp = instant.getEpochSecond() / 60L / 60L;
                break;
            }
            case MINUTES: {
                timestamp = instant.getEpochSecond() / 60L;
                break;
            }
            case SECONDS: {
                timestamp = instant.getEpochSecond();
                break;
            }
            case MILLISECONDS: {
                timestamp = instant.toEpochMilli();
                break;
            }
            case MICROSECONDS: {
                timestamp = instant.getEpochSecond() * 1000000L + (long)(instant.getNano() / 1000);
                break;
            }
            case NANOSECONDS: {
                timestamp = instant.getEpochSecond() * 1000000000L + (long)instant.getNano();
                break;
            }
            default: {
                timestamp = System.currentTimeMillis();
            }
        }
        return BitUtils.longToList(timestamp - this.epoch, this.getBits());
    }

    @Generated
    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    @Generated
    public long getEpoch() {
        return this.epoch;
    }

    @Override
    @Generated
    public int getBits() {
        return this.bits;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimestampBroIdPart)) {
            return false;
        }
        TimestampBroIdPart other = (TimestampBroIdPart)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEpoch() != other.getEpoch()) {
            return false;
        }
        if (this.getBits() != other.getBits()) {
            return false;
        }
        TimeUnit this$timeUnit = this.getTimeUnit();
        TimeUnit other$timeUnit = other.getTimeUnit();
        return !(this$timeUnit == null ? other$timeUnit != null : !((Object)((Object)this$timeUnit)).equals((Object)other$timeUnit));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TimestampBroIdPart;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $epoch = this.getEpoch();
        result = result * 59 + (int)($epoch ^ $epoch >>> 32);
        result = result * 59 + this.getBits();
        TimeUnit $timeUnit = this.getTimeUnit();
        result = result * 59 + ($timeUnit == null ? 43 : ((Object)((Object)$timeUnit)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TimestampBroIdPart(timeUnit=" + (Object)((Object)this.getTimeUnit()) + ", epoch=" + this.getEpoch() + ", bits=" + this.getBits() + ")";
    }

    @Generated
    public TimestampBroIdPart(TimeUnit timeUnit, long epoch, int bits) {
        this.timeUnit = timeUnit;
        this.epoch = epoch;
        this.bits = bits;
    }
}

