/*
 * Decompiled with CFR 0.152.
 */
package icu.congee.id.generator.cosid;

import icu.congee.id.base.Base62Codec;
import icu.congee.id.base.IdGenerator;
import icu.congee.id.base.IdType;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.Arrays;

public class CosIdGenerator
implements IdGenerator {
    private static final int TIMESTAMP_BITS = 44;
    private static final int MACHINE_ID_BITS = 20;
    private static final int SEQUENCE_BITS = 16;
    private static final long MAX_MACHINE_ID = 1048575L;
    private static final long MAX_SEQUENCE = 65535L;
    private final long epoch;
    private final long machineId;
    private long lastTimestamp = -1L;
    private long sequence = 0L;
    private static final CosIdGenerator cosIdGenerator = new CosIdGenerator();

    public CosIdGenerator() {
        this.epoch = 0L;
        this.machineId = 0L;
    }

    public CosIdGenerator(long machineId, long epoch) {
        if (machineId < 0L || machineId > 1048575L) {
            throw new IllegalArgumentException("Machine ID must be between 0 and 1048575");
        }
        this.machineId = machineId;
        this.epoch = epoch;
    }

    public static String next() {
        return Base62Codec.encode(cosIdGenerator.generateId());
    }

    public synchronized byte[] generateId() {
        long currentTimestamp = this.getCurrentTimestamp();
        if (currentTimestamp < this.lastTimestamp) {
            throw new RuntimeException("Clock moved backwards!");
        }
        if (currentTimestamp == this.lastTimestamp) {
            this.sequence = this.sequence + 1L & 0xFFFFL;
            if (this.sequence == 0L) {
                currentTimestamp = this.waitNextMillis(currentTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = currentTimestamp;
        return this.buildByteArray(currentTimestamp, this.machineId, this.sequence);
    }

    private byte[] buildByteArray(long timestamp, long machineId, long sequence) {
        ByteBuffer buffer = ByteBuffer.allocate(10);
        buffer.put((byte)(timestamp >>> 36));
        buffer.put((byte)(timestamp >>> 28 & 0xFFL));
        buffer.put((byte)(timestamp >>> 20 & 0xFFL));
        buffer.put((byte)(timestamp >>> 12 & 0xFFL));
        buffer.put((byte)(timestamp >>> 4 & 0xFFL));
        byte sixthByte = (byte)((timestamp & 0xFL) << 4);
        sixthByte = (byte)(sixthByte | (byte)(machineId >>> 16 & 0xFL));
        buffer.put(sixthByte);
        buffer.putShort((short)(machineId & 0xFFFFL));
        buffer.putShort((short)sequence);
        return buffer.array();
    }

    private long waitNextMillis(long currentTimestamp) {
        long now;
        while ((now = this.getCurrentTimestamp()) <= currentTimestamp) {
        }
        return now;
    }

    private long getCurrentTimestamp() {
        return System.currentTimeMillis() - this.epoch;
    }

    public static void main(String[] args) {
        long customEpoch = Instant.parse("2020-01-01T00:00:00Z").toEpochMilli();
        CosIdGenerator generator = new CosIdGenerator(703710L, customEpoch);
        byte[] id = generator.generateId();
        System.out.println("\u5b57\u8282\u6570\u7ec4: " + Arrays.toString(id));
        System.out.println("\u5341\u516d\u8fdb\u5236: " + CosIdGenerator.bytesToHex(id));
    }

    private static String bytesToHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        byte[] byArray = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            sb.append(String.format("%02x", b));
            ++n2;
        }
        return sb.toString();
    }

    @Override
    public Object generate() {
        return Base62Codec.encode(cosIdGenerator.generateId());
    }

    @Override
    public IdType idType() {
        return IdType.CosId;
    }
}

