/*
 * Decompiled with CFR 0.152.
 */
package icu.congee.id.generator.elasticflake;

import icu.congee.id.generator.elasticflake.Base64;
import icu.congee.id.generator.elasticflake.SecureRandomHolder;
import icu.congee.id.generator.elasticflake.UUIDGenerator;
import java.io.IOException;
import java.util.Random;

class RandomBasedUUIDGenerator
implements UUIDGenerator {
    RandomBasedUUIDGenerator() {
    }

    @Override
    public String getBase64UUID() {
        return this.getBase64UUID(SecureRandomHolder.INSTANCE);
    }

    public String getBase64UUID(Random random) {
        byte[] randomBytes = new byte[16];
        random.nextBytes(randomBytes);
        randomBytes[6] = (byte)(randomBytes[6] & 0xF);
        randomBytes[6] = (byte)(randomBytes[6] | 0x40);
        randomBytes[8] = (byte)(randomBytes[8] & 0x3F);
        randomBytes[8] = (byte)(randomBytes[8] | 0x80);
        try {
            byte[] encoded = Base64.encodeBytesToBytes(randomBytes, 0, randomBytes.length, 16);
            assert (encoded[encoded.length - 1] == 61);
            assert (encoded[encoded.length - 2] == 61);
            return new String(encoded, 0, encoded.length - 2, Base64.PREFERRED_ENCODING);
        }
        catch (IOException e) {
            throw new RuntimeException("should not be thrown");
        }
    }
}

