/*
 * Decompiled with CFR 0.152.
 */
package icu.congee.id.generator.uuid;

import icu.congee.id.base.IdGenerator;
import icu.congee.id.base.IdType;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.LongAdder;

public class UUIDv7Generator
implements IdGenerator {
    private static volatile long lastTimestamp = 0L;
    private static final LongAdder sequence = new LongAdder();

    public static synchronized UUID next() {
        long currentTime = System.currentTimeMillis();
        if (currentTime <= lastTimestamp) {
            sequence.increment();
        } else {
            sequence.reset();
            lastTimestamp = currentTime;
        }
        long msb = currentTime << 16 | 0x7000L | sequence.sum() & 0xFFFL;
        long lsb = Long.MIN_VALUE | ThreadLocalRandom.current().nextLong() & 0x3FFFFFFFFFFFFFFFL;
        return new UUID(msb, lsb);
    }

    @Override
    public String generate() {
        return UUIDv7Generator.next().toString();
    }

    @Override
    public IdType idType() {
        return IdType.UUIDv7;
    }
}

