# Sharding ID 生成器

## 简介

Sharding ID 生成器是一个基于 Instagram 的分布式 ID 生成算法实现的高性能唯一标识符生成器。它通过分片机制来保证 ID 的唯一性和有序性，特别适合在分布式系统中使用。

## ID 结构

生成的 ID 由以下三部分组成：

- 41 位时间戳（毫秒级，以 2011 年 1 月 1 日为基准）
- 13 位分片 ID（最多支持 8192 个分片）
- 10 位序列号（每毫秒最多生成 1024 个 ID）

## 特性

1. **分布式友好**

   - 支持多节点部署
   - 通过分片 ID 确保不同节点生成的 ID 唯一
   - 无需中心化协调

2. **高性能**

   - 纯内存操作，无需数据库交互
   - 支持批量生成
   - 每个分片每毫秒可生成 1024 个 ID

3. **有序性**
   - ID 按时间顺序递增
   - 同一毫秒内的 ID 按序列号递增
   - 便于数据库索引和查询优化

## 使用示例

```java
// 创建一个分片ID为5的生成器实例
InstagramIdGenerator idGenerator = new InstagramIdGenerator(5);

// 生成一个ID
long id = idGenerator.generateId();
```

## 注意事项

1. **分片 ID 的分配**

   - 需要确保在分布式环境中，每个节点的分片 ID 是唯一的
   - 分片 ID 的取值范围是[0, 8191]
   - 建议通过配置中心或其他方式统一分配分片 ID

2. **时钟同步**

   - 分布式系统中的各个节点需要进行时钟同步
   - 如果检测到时钟回拨，生成器会抛出异常
   - 建议使用 NTP 服务保持时钟同步

3. **性能考虑**
   - 单个分片每毫秒最多生成 1024 个 ID
   - 如果超过此限制，生成器会等待下一毫秒
   - 在高并发场景下，建议合理分配分片 ID，利用多个分片提高性能

## 应用场景

1. **分布式系统**

   - 分布式数据库的主键生成
   - 分布式服务的唯一标识
   - 分布式消息的消息 ID

2. **高并发系统**
   - 订单 ID 生成
   - 消息 ID 生成
   - 用户 ID 生成

## 性能优化建议

1. 根据系统规模合理分配分片数量
2. 在高并发场景下使用多个分片
3. 确保服务器时钟同步准确
4. 合理规划分片 ID 的分配策略
