# WxSeq 序列号生成器

## 简介

WxSeqGenerator 是一个模拟微信序列号生成器（seqsvr）的 Java 实现。它提供了一种高效、可靠的方式来为每个用户生成唯一的序列号，特别适用于需要按用户隔离的序列号生成场景。

## 核心特性

### 1. 用户隔离

- 基于用户 UID 进行序列号隔离
- 每个用户独立的序列号空间
- 通过 ThreadLocal 确保线程安全的用户上下文管理

### 2. 高性能设计

- 采用预分配机制，减少存储层访问
- 使用 ConcurrentHashMap 实现高并发支持
- 基于 AtomicLong 保证序列号的原子性递增

### 3. 预分配机制

- 默认步长为 10000
- 批量预分配序列号，减少存储层压力
- 异步持久化，提高响应速度

## 工作原理

1. **初始化**：

   - 首次使用时，为用户分配初始序列号（从 0 开始）
   - 使用 ConcurrentHashMap 存储每个用户的最大序列号

2. **序列号生成**：

   - 检查当前用户 UID
   - 获取该用户的序列号计数器
   - 原子性递增并返回序列号

3. **预分配策略**：
   - 当序列号达到步长边界时触发预分配
   - 更新最大序列号并异步持久化
   - 确保序列号连续性

## 使用示例

```java
// 设置当前用户ID
WxSeqGenerator.setCurrentUid(1001L);

// 创建生成器实例
WxSeqGenerator generator = new WxSeqGenerator();

// 生成序列号
Object sequence = generator.generate();

// 使用完毕后清理
WxSeqGenerator.clearCurrentUid();
```

## 性能考虑

1. **内存效率**

   - 仅存储活跃用户的序列号状态
   - 使用 ThreadLocal 避免线程同步开销

2. **并发性能**

   - 用户级别的序列号隔离，避免全局锁
   - ConcurrentHashMap 提供高效的并发访问
   - AtomicLong 确保原子性操作

3. **I/O 优化**
   - 批量预分配减少存储层访问频率
   - 异步持久化避免同步 I/O 阻塞

## 注意事项

1. 使用前必须通过`setCurrentUid`设置用户 ID
2. 使用完毕后建议调用`clearCurrentUid`清理线程变量
3. 实际生产环境中需要实现持久化存储层
4. 预分配步长可根据业务需求调整

## 对比优势

相比其他 ID 生成器：

1. **用户隔离**：每个用户独立的序列号空间，避免混淆
2. **高性能**：预分配机制显著减少存储访问
3. **简单可靠**：实现简单，易于理解和维护
4. **可扩展**：可以轻松扩展存储层实现

## 适用场景

- 需要按用户隔离的序列号生成
- 高并发的序列号分配场景
- 要求序列号连续的业务场景
- 类似微信消息 ID 的应用场景
