# UUID 生成器

## 概述

UUID（通用唯一标识符）是一个 128 位的全局唯一标识符，用于在分布式系统中生成唯一的标识。本生成器支持多个 UUID 版本（v1-v8），每个版本都有其特定的用途和优势。

## UUID 版本特性

### UUID v1（基于时间的 UUID）

- 基于时间戳和节点 ID 生成
- 包含 48 位时间戳（100ns 精度）
- 包含 48 位节点标识（通常是 MAC 地址）
- 适用于需要时间排序的场景
- 可能存在隐私问题（暴露 MAC 地址）

### UUID v2（DCE 安全 UUID）

- 基于 v1 的变体，增加了安全特性
- 包含本地域（Local Domain）信息
- 主要用于 POSIX 系统
- 使用较少，因为规范未完全公开

### UUID v3（基于名字的 UUID，MD5）

- 基于名字空间和名字的 MD5 哈希
- 相同输入产生相同输出
- 适用于需要确定性 UUID 的场景
- MD5 算法存在碰撞风险

### UUID v4（随机 UUID）

- 完全基于随机或伪随机数
- 简单且使用最广泛
- 无序，不支持时间排序
- 适用于大多数通用场景

### UUID v5（基于名字的 UUID，SHA1）

- 基于名字空间和名字的 SHA1 哈希
- 比 v3 更安全（使用 SHA1）
- 相同输入产生相同输出
- 适用于需要确定性且安全性较高的场景

### UUID v6（重排序的时间 UUID）

- v1 的改进版本
- 时间戳位于最显著位置
- 更好的时间排序性能
- 保持与 v1 的兼容性

### UUID v7（基于 Unix 时间戳的 UUID）

- 使用 48 位 Unix 毫秒时间戳
- 更好的时间排序性能
- 更符合现代系统的时间表示
- 推荐用于新系统

### UUID v8（自定义 UUID）

- 允许自定义格式
- 保留版本和变体位
- 灵活性最高
- 适用于特殊需求场景

## 性能考虑

- v1/v2：性能较好，但需要维护时钟序列
- v3/v5：需要计算哈希，性能相对较低
- v4：性能优秀，生成速度快
- v6/v7：性能优秀，且支持时间排序
- v8：性能取决于具体实现

## 版本选择建议

1. 需要时间排序：优先选择 v7，其次 v6
2. 通用场景：使用 v4
3. 基于名字的确定性 UUID：优先 v5，其次 v3
4. 特殊需求：考虑 v8

## 使用示例

```java
UUID uuid = UUID.randomUUID(); // v4
String uuidString = uuid.toString();
```

## 注意事项

1. UUID 不保证连续性
2. 不同版本有不同的安全性考虑
3. 在分布式系统中使用时需注意时钟同步问题
4. 存储时建议使用二进制格式而非字符串格式
