/*
 * Decompiled with CFR 0.152.
 */
package icu.congee.id.generator.broid;

import icu.congee.id.base.Base64;
import icu.congee.id.base.IdType;
import icu.congee.id.generator.broid.BitUtils;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import lombok.Generated;

public class BroId
implements Comparable<BroId> {
    private final String name = "BroId";
    private final String desc = "Custom Id";
    private final List<Boolean> value;

    public String toString() {
        return Base64.encode(BitUtils.listToByteArray(this.value));
    }

    public Long toLong() {
        return BitUtils.listToLong(this.value);
    }

    public UUID toUUID() {
        long msb = BitUtils.listToLong(this.value.subList(0, 64));
        long lsb = BitUtils.listToLong(this.value.subList(64, 128));
        return new UUID(msb, lsb);
    }

    public UUID toUUID(IdType idType) {
        if (idType == IdType.UUIDv8) {
            this.value.set(48, true);
            this.value.set(49, false);
            this.value.set(50, false);
            this.value.set(51, false);
            this.value.set(64, true);
            this.value.set(65, false);
            long msb = BitUtils.listToLong(this.value.subList(0, 64));
            long lsb = BitUtils.listToLong(this.value.subList(64, 128));
            return new UUID(msb, lsb);
        }
        return null;
    }

    @Override
    public int compareTo(BroId other) {
        if (other == null) {
            return 1;
        }
        if (this.value == null) {
            return other.value == null ? 0 : -1;
        }
        if (other.value == null) {
            return 1;
        }
        int sizeComparison = Integer.compare(this.value.size(), other.value.size());
        if (sizeComparison != 0) {
            return sizeComparison;
        }
        for (int i = 0; i < this.value.size(); ++i) {
            boolean bit2;
            boolean bit1 = this.value.get(i);
            if (bit1 == (bit2 = other.value.get(i).booleanValue())) continue;
            return bit1 ? 1 : -1;
        }
        return 0;
    }

    public static Comparator<BroId> getComparator() {
        return Comparator.nullsFirst(Comparator.comparing(BroId::getValue, (list1, list2) -> {
            if (list1 == null && list2 == null) {
                return 0;
            }
            if (list1 == null) {
                return -1;
            }
            if (list2 == null) {
                return 1;
            }
            int sizeComparison = Integer.compare(list1.size(), list2.size());
            if (sizeComparison != 0) {
                return sizeComparison;
            }
            for (int i = 0; i < list1.size(); ++i) {
                boolean bit2;
                boolean bit1 = (Boolean)list1.get(i);
                if (bit1 == (bit2 = ((Boolean)list2.get(i)).booleanValue())) continue;
                return bit1 ? 1 : -1;
            }
            return 0;
        }));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BroId broId = (BroId)o;
        if (this.value == null) {
            return broId.value == null;
        }
        if (broId.value == null) {
            return false;
        }
        if (this.value.size() != broId.value.size()) {
            return false;
        }
        for (int i = 0; i < this.value.size(); ++i) {
            if (this.value.get(i) == broId.value.get(i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.value.toArray());
    }

    @Generated
    public BroId(List<Boolean> value) {
        this.value = value;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDesc() {
        return this.desc;
    }

    @Generated
    public List<Boolean> getValue() {
        return this.value;
    }
}

