/*
 * Decompiled with CFR 0.152.
 */
package icu.congee.id.generator.ksuid;

import icu.congee.id.generator.ksuid.Ksuid;
import java.security.SecureRandom;
import java.time.Clock;
import java.time.Instant;
import java.util.Random;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.LongSupplier;
import java.util.function.Supplier;

public final class KsuidFactory {
    private final Supplier<Instant> instantFunction;
    private final Function<Instant, Ksuid> ksuidFunction;
    private final ReentrantLock lock = new ReentrantLock();
    static final int PRECISION_MILLISECOND = 1;
    static final int PRECISION_MICROSECOND = 2;
    static final int PRECISION_NANOSECOND = 3;

    public KsuidFactory() {
        this(new KsuidFunction(IRandom.newInstance()));
    }

    KsuidFactory(Function<Instant, Ksuid> ksuidFunction) {
        this(ksuidFunction, null);
    }

    KsuidFactory(Function<Instant, Ksuid> ksuidFunction, Supplier<Instant> instantFunction) {
        this.ksuidFunction = ksuidFunction;
        this.instantFunction = instantFunction != null ? instantFunction : () -> Clock.systemUTC().instant();
    }

    public static KsuidFactory newInstance() {
        return new KsuidFactory();
    }

    public static KsuidFactory newInstance(Random random) {
        return new KsuidFactory(new KsuidFunction(IRandom.newInstance(random)));
    }

    public static KsuidFactory newInstance(LongSupplier randomFunction) {
        return new KsuidFactory(new KsuidFunction(IRandom.newInstance(randomFunction)));
    }

    public static KsuidFactory newInstance(IntFunction<byte[]> randomFunction) {
        return new KsuidFactory(new KsuidFunction(IRandom.newInstance(randomFunction)));
    }

    public static KsuidFactory newSubsecondInstance() {
        return new KsuidFactory(KsuidFactory.getSubsecondFunction(new ByteRandom()));
    }

    public static KsuidFactory newSubsecondInstance(Random random) {
        return new KsuidFactory(KsuidFactory.getSubsecondFunction(IRandom.newInstance(random)));
    }

    public static KsuidFactory newSubsecondInstance(LongSupplier randomFunction) {
        return new KsuidFactory(KsuidFactory.getSubsecondFunction(new LongRandom(randomFunction)));
    }

    public static KsuidFactory newSubsecondInstance(IntFunction<byte[]> randomFunction) {
        return new KsuidFactory(KsuidFactory.getSubsecondFunction(new ByteRandom(randomFunction)));
    }

    public static KsuidFactory newSubsecondInstance(Random random, Supplier<Instant> instantFunction) {
        return new KsuidFactory(KsuidFactory.getSubsecondFunction(IRandom.newInstance(random)), instantFunction);
    }

    public static KsuidFactory newSubsecondInstance(LongSupplier randomFunction, Supplier<Instant> instantFunction) {
        return new KsuidFactory(KsuidFactory.getSubsecondFunction(new LongRandom(randomFunction)), instantFunction);
    }

    public static KsuidFactory newSubsecondInstance(IntFunction<byte[]> randomFunction, Supplier<Instant> instantFunction) {
        return new KsuidFactory(KsuidFactory.getSubsecondFunction(new ByteRandom(randomFunction)), instantFunction);
    }

    public static KsuidFactory newMonotonicInstance() {
        return new KsuidFactory(new MonotonicFunction(IRandom.newInstance()));
    }

    public static KsuidFactory newMonotonicInstance(Random random) {
        return new KsuidFactory(new MonotonicFunction(IRandom.newInstance(random)));
    }

    public static KsuidFactory newMonotonicInstance(LongSupplier randomFunction) {
        return new KsuidFactory(new MonotonicFunction(IRandom.newInstance(randomFunction)));
    }

    public static KsuidFactory newMonotonicInstance(IntFunction<byte[]> randomFunction) {
        return new KsuidFactory(new MonotonicFunction(IRandom.newInstance(randomFunction)));
    }

    public static KsuidFactory newMonotonicInstance(Random random, Supplier<Instant> instantFunction) {
        return new KsuidFactory(new MonotonicFunction(IRandom.newInstance(random)), instantFunction);
    }

    public static KsuidFactory newMonotonicInstance(LongSupplier randomFunction, Supplier<Instant> instantFunction) {
        return new KsuidFactory(new MonotonicFunction(IRandom.newInstance(randomFunction)), instantFunction);
    }

    public static KsuidFactory newMonotonicInstance(IntFunction<byte[]> randomFunction, Supplier<Instant> instantFunction) {
        return new KsuidFactory(new MonotonicFunction(IRandom.newInstance(randomFunction)), instantFunction);
    }

    public Ksuid create() {
        return this.create(this.instantFunction.get());
    }

    public Ksuid create(Instant instant) {
        this.lock.lock();
        try {
            Ksuid ksuid = this.ksuidFunction.apply(instant);
            return ksuid;
        }
        finally {
            this.lock.unlock();
        }
    }

    static Function<Instant, Ksuid> getSubsecondFunction(IRandom random) {
        int precision = KsuidFactory.getSubsecondPrecision(Clock.systemUTC());
        switch (precision) {
            case 1: {
                return new MillisecondFunction(random);
            }
            case 2: {
                return new MicrosecondFunction(random);
            }
            case 3: {
                return new NanosecondFunction(random);
            }
        }
        return new MillisecondFunction(random);
    }

    static int getSubsecondPrecision(Clock clock) {
        int best = 0;
        int loop = 3;
        for (int i = 0; i < loop; ++i) {
            if (i > 0) {
                try {
                    Thread.sleep(0L, 1);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            int x = 0;
            int nanosecond = clock.instant().getNano();
            x = nanosecond % 1000 != 0 ? 3 : (nanosecond % 1000000 != 0 ? 2 : 1);
            best = Math.max(best, x);
        }
        return best;
    }

    static final class KsuidFunction
    implements Function<Instant, Ksuid> {
        private final IRandom random;

        public KsuidFunction(IRandom random) {
            this.random = random;
        }

        @Override
        public Ksuid apply(Instant instant) {
            return new Ksuid(instant.getEpochSecond(), this.random.nextBytes(16));
        }
    }

    static interface IRandom {
        public long nextLong();

        public byte[] nextBytes(int var1);

        public static IRandom newInstance() {
            return new ByteRandom();
        }

        public static IRandom newInstance(Random random) {
            if (random == null) {
                return new ByteRandom();
            }
            if (random instanceof SecureRandom) {
                return new ByteRandom(random);
            }
            return new LongRandom(random);
        }

        public static IRandom newInstance(LongSupplier randomFunction) {
            return new LongRandom(randomFunction);
        }

        public static IRandom newInstance(IntFunction<byte[]> randomFunction) {
            return new ByteRandom(randomFunction);
        }
    }

    static class ByteRandom
    implements IRandom {
        private final IntFunction<byte[]> randomFunction;

        public ByteRandom() {
            this(ByteRandom.newRandomFunction(null));
        }

        public ByteRandom(Random random) {
            this(ByteRandom.newRandomFunction(random));
        }

        public ByteRandom(IntFunction<byte[]> randomFunction) {
            this.randomFunction = randomFunction != null ? randomFunction : ByteRandom.newRandomFunction(null);
        }

        @Override
        public long nextLong() {
            long number = 0L;
            byte[] bytes = this.randomFunction.apply(8);
            for (int i = 0; i < 8; ++i) {
                number = number << 8 | (long)(bytes[i] & 0xFF);
            }
            return number;
        }

        @Override
        public byte[] nextBytes(int length) {
            return this.randomFunction.apply(length);
        }

        protected static IntFunction<byte[]> newRandomFunction(Random random) {
            Random entropy = random != null ? random : new SecureRandom();
            return length -> {
                byte[] bytes = new byte[length];
                entropy.nextBytes(bytes);
                return bytes;
            };
        }
    }

    static class LongRandom
    implements IRandom {
        private final LongSupplier randomFunction;

        public LongRandom() {
            this(LongRandom.newRandomFunction(null));
        }

        public LongRandom(Random random) {
            this(LongRandom.newRandomFunction(random));
        }

        public LongRandom(LongSupplier randomFunction) {
            this.randomFunction = randomFunction != null ? randomFunction : LongRandom.newRandomFunction(null);
        }

        @Override
        public long nextLong() {
            return this.randomFunction.getAsLong();
        }

        @Override
        public byte[] nextBytes(int length) {
            int shift = 0;
            long random = 0L;
            byte[] bytes = new byte[length];
            for (int i = 0; i < length; ++i) {
                if (shift < 8) {
                    shift = 64;
                    random = this.randomFunction.getAsLong();
                }
                bytes[i] = (byte)(random >>> (shift -= 8));
            }
            return bytes;
        }

        protected static LongSupplier newRandomFunction(Random random) {
            Random entropy = random != null ? random : new SecureRandom();
            return entropy::nextLong;
        }
    }

    static final class MonotonicFunction
    implements Function<Instant, Ksuid> {
        private Ksuid lastKsuid;
        private final IRandom random;
        protected static final long CLOCK_DRIFT_TOLERANCE = 10L;

        protected MonotonicFunction(IRandom random) {
            this.random = random;
            this.lastKsuid = new Ksuid(0L, random.nextBytes(16));
        }

        @Override
        public Ksuid apply(Instant instant) {
            long lastTime;
            long time = instant.getEpochSecond();
            this.lastKsuid = time > (lastTime = this.lastKsuid.getTime()) - 10L && time <= lastTime ? this.lastKsuid.increment() : new Ksuid(time, this.random.nextBytes(16));
            return new Ksuid(this.lastKsuid);
        }
    }

    static final class MillisecondFunction
    implements Function<Instant, Ksuid> {
        private final IRandom random;

        public MillisecondFunction(IRandom random) {
            this.random = random;
        }

        @Override
        public Ksuid apply(Instant instant) {
            byte[] payload = this.random.nextBytes(16);
            int milliseconds = instant.getNano() / 1000000;
            int subsecs = milliseconds << 6 | payload[1] & 0x3F;
            payload[0] = (byte)(subsecs >>> 8 & 0xFF);
            payload[1] = (byte)(subsecs >>> 0 & 0xFF);
            return new Ksuid(instant.getEpochSecond(), payload);
        }
    }

    static final class MicrosecondFunction
    implements Function<Instant, Ksuid> {
        private final IRandom random;

        public MicrosecondFunction(IRandom random) {
            this.random = random;
        }

        @Override
        public Ksuid apply(Instant instant) {
            byte[] payload = this.random.nextBytes(16);
            int microseconds = instant.getNano() / 1000;
            int subsecs = microseconds << 4 | payload[2] & 0xF;
            payload[0] = (byte)(subsecs >>> 16 & 0xFF);
            payload[1] = (byte)(subsecs >>> 8 & 0xFF);
            payload[2] = (byte)(subsecs >>> 0 & 0xFF);
            return new Ksuid(instant.getEpochSecond(), payload);
        }
    }

    static final class NanosecondFunction
    implements Function<Instant, Ksuid> {
        private final IRandom random;

        public NanosecondFunction(IRandom random) {
            this.random = random;
        }

        @Override
        public Ksuid apply(Instant instant) {
            byte[] payload = this.random.nextBytes(16);
            int nanoseconds = instant.getNano();
            int subsecs = nanoseconds << 2 | payload[3] & 3;
            payload[0] = (byte)(subsecs >>> 24 & 0xFF);
            payload[1] = (byte)(subsecs >>> 16 & 0xFF);
            payload[2] = (byte)(subsecs >>> 8 & 0xFF);
            payload[3] = (byte)(subsecs >>> 0 & 0xFF);
            return new Ksuid(instant.getEpochSecond(), payload);
        }
    }
}

