/*
 * Decompiled with CFR 0.152.
 */
package icu.congee.id.generator.uuid;

import java.util.UUID;

public class FastUUIDToString {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final int UUID_STRING_LENGTH = 36;
    private static final int[] DASH_POSITIONS = new int[]{8, 13, 18, 23};
    private static final ThreadLocal<char[]> CHAR_BUFFER = ThreadLocal.withInitial(() -> new char[36]);

    public static String toString(UUID uuid) {
        if (uuid == null) {
            return null;
        }
        long mostSigBits = uuid.getMostSignificantBits();
        long leastSigBits = uuid.getLeastSignificantBits();
        char[] chars = CHAR_BUFFER.get();
        FastUUIDToString.formatHex(chars, mostSigBits >> 32, 0, 8);
        chars[8] = 45;
        FastUUIDToString.formatHex(chars, mostSigBits >> 16, 9, 4);
        chars[13] = 45;
        FastUUIDToString.formatHex(chars, mostSigBits, 14, 4);
        chars[18] = 45;
        FastUUIDToString.formatHex(chars, leastSigBits >> 48, 19, 4);
        chars[23] = 45;
        FastUUIDToString.formatHex(chars, leastSigBits, 24, 12);
        return new String(chars);
    }

    private static void formatHex(char[] chars, long value, int offset, int digits) {
        for (int i = 0; i < digits; ++i) {
            int hexDigit = (int)(value >> (digits - 1 - i) * 4) & 0xF;
            chars[offset + i] = HEX_DIGITS[hexDigit];
        }
    }
}

