/*
 * Decompiled with CFR 0.152.
 */
package icu.congee.id.generator.uuid;

import icu.congee.id.base.IdGenerator;
import icu.congee.id.base.IdType;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;

public class UUIDv8Generator
implements IdGenerator {
    private static final long TIMESTAMP_MASK = 0xFFFFFFFFFFFFL;
    private static final long VERSION_IDENTIFIER = 32768L;
    private static final long SEQUENCE_MASK = 4095L;
    private static final long VARIANT_IDENTIFIER = Long.MIN_VALUE;
    private static final long anInt = 0x3FFFFFFFL;
    private static final ThreadLocal<ThreadLocalSequence> threadLocalTimestampSeq = ThreadLocal.withInitial(ThreadLocalSequence::new);

    public static UUID next() {
        ThreadLocalSequence seq = threadLocalTimestampSeq.get();
        long timestamp = System.currentTimeMillis() & 0xFFFFFFFFFFFFL;
        long sequence = seq.sequence++ & 0x3FFFL;
        long mostSigBits = timestamp << 16 | 0x8000L | sequence & 0xFFFL;
        long leastSigBits = Long.MIN_VALUE | ThreadLocalRandom.current().nextLong() & 0x3FFFFFFFFFFFFFFFL;
        return new UUID(mostSigBits, leastSigBits);
    }

    @Override
    public String generate() {
        return UUIDv8Generator.next().toString();
    }

    @Override
    public IdType idType() {
        return IdType.UUIDv8;
    }

    private static class ThreadLocalSequence {
        long sequence;

        private ThreadLocalSequence() {
        }
    }
}

