# FlexID 算法

FlexID 是一个简单、高效且易于使用的分布式 ID 生成算法。它专为分布式系统设计，能够生成全局唯一、趋势递增的 ID，同时支持分库分表场景下的负载均衡。

## 特性

- **时间单调递增**：保证生成的 ID 按时间顺序递增，便于排序和查询
- **高并发支持**：单机支持每秒 10 万级别的 ID 生成
- **分布式友好**：最大支持 99 台机器集群部署
- **时钟回拨处理**：运行时自动处理时钟回拨问题
- **分库分表友好**：ID 末尾包含随机数，确保分片均衡
- **使用寿命长**：基于 2024 年基准时间戳，可使用约 300 年

## ID 结构

FlexID 由以下四个部分组成：

```
时间戳差值（7+位）| 序列号（2位：00-99）| 机器ID（2位：00-99）| 随机数（2位：00-99）
```

- **时间戳差值**：当前时间与基准时间（2024-04-02）的毫秒差值
- **序列号**：同一毫秒内的自增序列，取值范围 00-99
- **机器 ID**：机器标识，取值范围 00-99，支持最多 100 台机器
- **随机数**：随机生成的两位数，用于分库分表时的均衡分布

## 使用示例

```java
// 创建默认的FlexID生成器（机器ID默认为1）
FlexIDKeyGenerator generator = new FlexIDKeyGenerator();

// 创建指定机器ID的FlexID生成器
FlexIDKeyGenerator generator = new FlexIDKeyGenerator(5); // 机器ID为5

// 生成ID
Long id = generator.generate();
```

## 性能与限制

### 性能优势

- 单机每秒可生成 10 万个 ID
- 趋势递增，适合用作数据库主键
- 支持分布式环境，无需中心化协调

### 使用限制

1. 单机每秒最大生成 10 万个 ID
2. 在时钟回拨且服务重启的情况下，可能出现 ID 重复
3. 机器 ID 需要手动配置，范围为 0-99

## 最佳实践

1. **机器 ID 分配**：在分布式环境中，建议通过配置中心统一分配机器 ID，确保集群内唯一
2. **分库分表场景**：可以通过 ID 对 100 取模，利用末尾的随机数实现数据均匀分布
3. **时钟同步**：建议服务器启用 NTP 时间同步，减少时钟回拨的发生

## 许可证

本项目采用 MIT 许可证，详见 LICENSE 文件。
