package icu.congee.id.generator.mist;

import icu.congee.id.base.IdGenerator;

/**
 * 薄雾算法 Java 实现
 *
 * 1 2 48 56 64
 * +------+-----------------------------------------------------+----------+----------+
 * retain | increas | salt | sequence |
 * +------+-----------------------------------------------------+----------+----------+
 * 0 | 0000000000 0000000000 0000000000 0000000 0000000000 | 00000000 | 00000000
 * |
 * +------+-----------------------------------------------------+------------+--------+
 *
 * 0. 最高位，占 1 位，保持为 0，使得值永远为正数；
 * 1. 自增数，占 47 位，自增数在高位能保证结果值呈递增态势，遂低位可以为所欲为；
 * 2. 随机因子一，占 8 位，上限数值 255，使结果值不可预测；
 * 3. 随机因子二，占 8 位，上限数值 255，使结果值不可预测；
 *
 * 编号上限为百万亿级，上限值计算为 140737488355327 即 (1L << 47) - 1，假设每天取值 10 亿，能使用 385+ 年
 */

/**
 * 薄雾算法接口
 */
public interface MistGenerator extends IdGenerator { }