/*
 * Decompiled with CFR 0.152.
 */
package icu.congee.id.base;

import java.util.Arrays;

public class Base16 {
    private static final byte[] ENCODE_MAP;
    private static final byte[] DECODE_MAP;

    public static String encode(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return "";
        }
        StringBuilder result = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            result.append((char)ENCODE_MAP[b >> 4 & 0xF]);
            result.append((char)ENCODE_MAP[b & 0xF]);
        }
        return result.toString();
    }

    public static byte[] decode(String str) {
        if (str == null || str.isEmpty()) {
            return new byte[0];
        }
        if (str.length() % 2 != 0) {
            throw new IllegalArgumentException("Invalid Base16 string length");
        }
        byte[] result = new byte[str.length() / 2];
        for (int i = 0; i < str.length(); i += 2) {
            char high = str.charAt(i);
            char low = str.charAt(i + 1);
            if (high >= '\u0080' || low >= '\u0080' || DECODE_MAP[high] == -1 || DECODE_MAP[low] == -1) {
                throw new IllegalArgumentException("Invalid Base16 character");
            }
            result[i / 2] = (byte)(DECODE_MAP[high] << 4 | DECODE_MAP[low]);
        }
        return result;
    }

    static {
        int i;
        ENCODE_MAP = new byte[16];
        for (i = 0; i < 10; ++i) {
            Base16.ENCODE_MAP[i] = (byte)(48 + i);
        }
        for (i = 10; i < 16; ++i) {
            Base16.ENCODE_MAP[i] = (byte)(65 + (i - 10));
        }
        DECODE_MAP = new byte[128];
        Arrays.fill(DECODE_MAP, (byte)-1);
        for (i = 0; i < 10; ++i) {
            Base16.DECODE_MAP[48 + i] = (byte)i;
        }
        for (i = 0; i < 6; ++i) {
            Base16.DECODE_MAP[65 + i] = (byte)(10 + i);
            Base16.DECODE_MAP[97 + i] = (byte)(10 + i);
        }
    }
}

