/*
 * Decompiled with CFR 0.152.
 */
package icu.congee.id.generator.broid.part;

import icu.congee.id.generator.broid.BitUtils;
import icu.congee.id.generator.broid.BroIdPart;
import java.time.Instant;
import java.util.List;
import java.util.concurrent.TimeUnit;
import lombok.Generated;

public class TimestampBroIdPart
implements BroIdPart {
    private final TimeUnit timeUnit;
    private final long epoch;
    private final int bits;

    @Override
    public List<Boolean> next() {
        Instant instant = Instant.now();
        return BitUtils.longToList((switch (this.timeUnit) {
            case TimeUnit.DAYS -> instant.getEpochSecond() / 60L / 60L / 24L;
            case TimeUnit.HOURS -> instant.getEpochSecond() / 60L / 60L;
            case TimeUnit.MINUTES -> instant.getEpochSecond() / 60L;
            case TimeUnit.SECONDS -> instant.getEpochSecond();
            case TimeUnit.MILLISECONDS -> instant.toEpochMilli();
            case TimeUnit.MICROSECONDS -> instant.getEpochSecond() * 1000000L + (long)(instant.getNano() / 1000);
            case TimeUnit.NANOSECONDS -> instant.getEpochSecond() * 1000000000L + (long)instant.getNano();
            default -> System.currentTimeMillis();
        }) - this.epoch, this.getBits());
    }

    @Generated
    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    @Generated
    public long getEpoch() {
        return this.epoch;
    }

    @Override
    @Generated
    public int getBits() {
        return this.bits;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimestampBroIdPart)) {
            return false;
        }
        TimestampBroIdPart other = (TimestampBroIdPart)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEpoch() != other.getEpoch()) {
            return false;
        }
        if (this.getBits() != other.getBits()) {
            return false;
        }
        TimeUnit this$timeUnit = this.getTimeUnit();
        TimeUnit other$timeUnit = other.getTimeUnit();
        return !(this$timeUnit == null ? other$timeUnit != null : !((Object)((Object)this$timeUnit)).equals((Object)other$timeUnit));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TimestampBroIdPart;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $epoch = this.getEpoch();
        result = result * 59 + (int)($epoch >>> 32 ^ $epoch);
        result = result * 59 + this.getBits();
        TimeUnit $timeUnit = this.getTimeUnit();
        result = result * 59 + ($timeUnit == null ? 43 : ((Object)((Object)$timeUnit)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TimestampBroIdPart(timeUnit=" + String.valueOf((Object)this.getTimeUnit()) + ", epoch=" + this.getEpoch() + ", bits=" + this.getBits() + ")";
    }

    @Generated
    public TimestampBroIdPart(TimeUnit timeUnit, long epoch, int bits) {
        this.timeUnit = timeUnit;
        this.epoch = epoch;
        this.bits = bits;
    }
}

