/*
 * Decompiled with CFR 0.152.
 */
package icu.congee.id.generator.custom;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.security.SecureRandom;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;

public class EntropyKey {
    private static final AtomicLong COUNTER = new AtomicLong(0L);
    private static final SecureRandom SECURE_RANDOM = new SecureRandom();
    private static final long NODE = EntropyKey.initializeNodeIdentifier();
    private final long timestamp = System.nanoTime();
    private final long counter = COUNTER.getAndIncrement();
    private final long node = NODE;
    private final long secureRandom = SECURE_RANDOM.nextLong();

    private static long initializeNodeIdentifier() {
        try {
            byte[] mac;
            InetAddress ip = InetAddress.getLocalHost();
            NetworkInterface network = NetworkInterface.getByInetAddress(ip);
            if (network != null && (mac = network.getHardwareAddress()) != null) {
                long node = 0L;
                for (int i = 0; i < Math.min(6, mac.length); ++i) {
                    node = node << 8 | (long)(mac[i] & 0xFF);
                }
                return node;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return SECURE_RANDOM.nextLong() & 0xFFFFFFFFFFFFL;
    }

    @Generated
    public long getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public long getCounter() {
        return this.counter;
    }

    @Generated
    public long getNode() {
        return this.node;
    }

    @Generated
    public long getSecureRandom() {
        return this.secureRandom;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EntropyKey)) {
            return false;
        }
        EntropyKey other = (EntropyKey)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTimestamp() != other.getTimestamp()) {
            return false;
        }
        if (this.getCounter() != other.getCounter()) {
            return false;
        }
        if (this.getNode() != other.getNode()) {
            return false;
        }
        return this.getSecureRandom() == other.getSecureRandom();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EntropyKey;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $timestamp = this.getTimestamp();
        result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        long $counter = this.getCounter();
        result = result * 59 + (int)($counter >>> 32 ^ $counter);
        long $node = this.getNode();
        result = result * 59 + (int)($node >>> 32 ^ $node);
        long $secureRandom = this.getSecureRandom();
        result = result * 59 + (int)($secureRandom >>> 32 ^ $secureRandom);
        return result;
    }

    @Generated
    public String toString() {
        return "EntropyKey(timestamp=" + this.getTimestamp() + ", counter=" + this.getCounter() + ", node=" + this.getNode() + ", secureRandom=" + this.getSecureRandom() + ")";
    }
}

