/*
 * Decompiled with CFR 0.152.
 */
package icu.congee.id.generator.custom;

import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.security.SecureRandom;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;

public class EntropySourceContainer {
    private final long systemBootTime = System.currentTimeMillis() / 1000L;
    private final String macAddress = EntropySourceContainer.getMacAddress();
    private final String ipAddress = EntropySourceContainer.getIpAddress();
    private final String processId = EntropySourceContainer.getProcessId();
    private final String hostName = EntropySourceContainer.getHostName();
    private final int threadId = (int)Thread.currentThread().getId();
    private final int secureRandomInt = SECURE_RANDOM.nextInt();
    private final int counter = COUNTER.getAndIncrement();
    private final String osName = System.getProperty("os.name", "unknown");
    private final String javaVersion = System.getProperty("java.version", "unknown");
    private final String userName = System.getProperty("user.name", "unknown");
    private final String userDir = System.getProperty("user.dir", "unknown");
    private final String envVarsHash = EntropySourceContainer.getEnvironmentVariablesHash();
    private final String filesystemRoots = EntropySourceContainer.getFilesystemRoots();
    private final String jvmArgs = ManagementFactory.getRuntimeMXBean().getInputArguments().toString();
    private final int cpuCores = Runtime.getRuntime().availableProcessors();
    private final long jvmStartTime = ManagementFactory.getRuntimeMXBean().getStartTime();
    private final long totalPhysicalMemory = EntropySourceContainer.getTotalPhysicalMemory();
    private final String jvmVendor = System.getProperty("java.vm.vendor", "unknown");
    private final String osArch = System.getProperty("os.arch", "unknown");
    private final String osVersion = System.getProperty("os.version", "unknown");
    private static final AtomicInteger COUNTER = new AtomicInteger(0);
    private static final SecureRandom SECURE_RANDOM = new SecureRandom();

    private static String getMacAddress() {
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                byte[] mac;
                NetworkInterface iface = interfaces.nextElement();
                if (iface.isLoopback() || !iface.isUp() || (mac = iface.getHardwareAddress()) == null) continue;
                StringBuilder sb = new StringBuilder();
                for (byte b : mac) {
                    sb.append(String.format("%02X:", b));
                }
                return sb.deleteCharAt(sb.length() - 1).toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "00:00:00:00:00:00";
    }

    private static String getIpAddress() {
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface iface = interfaces.nextElement();
                if (iface.isLoopback() || !iface.isUp()) continue;
                Enumeration<InetAddress> addresses = iface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress addr = addresses.nextElement();
                    if (addr.isLoopbackAddress() || !(addr instanceof Inet4Address)) continue;
                    return addr.getHostAddress();
                }
            }
        }
        catch (Exception interfaces) {
            // empty catch block
        }
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception ignored) {
            return "0.0.0.0";
        }
    }

    private static String getProcessId() {
        String name = ManagementFactory.getRuntimeMXBean().getName();
        if (name.contains("@")) {
            return name.split("@")[0];
        }
        return "unknown";
    }

    private static String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            return "unknown";
        }
    }

    private static String getEnvironmentVariablesHash() {
        Map<String, String> env = System.getenv();
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : env.entrySet()) {
            sb.append(entry.getKey()).append("=").append(entry.getValue()).append(";");
        }
        return sb.toString();
    }

    private static String getFilesystemRoots() {
        StringBuilder sb = new StringBuilder();
        for (Path root : FileSystems.getDefault().getRootDirectories()) {
            sb.append(root).append(":");
        }
        return sb.toString();
    }

    private static long getTotalPhysicalMemory() {
        OperatingSystemMXBean bean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        return bean.getTotalMemorySize();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EntropySourceContainer)) {
            return false;
        }
        EntropySourceContainer that = (EntropySourceContainer)o;
        return this.systemBootTime == that.systemBootTime && this.threadId == that.threadId && this.counter == that.counter && this.cpuCores == that.cpuCores && Objects.equals(this.macAddress, that.macAddress) && Objects.equals(this.ipAddress, that.ipAddress) && Objects.equals(this.processId, that.processId) && Objects.equals(this.hostName, that.hostName) && this.secureRandomInt == that.secureRandomInt && Objects.equals(this.osName, that.osName) && Objects.equals(this.javaVersion, that.javaVersion) && Objects.equals(this.userName, that.userName) && Objects.equals(this.userDir, that.userDir) && Objects.equals(this.envVarsHash, that.envVarsHash) && Objects.equals(this.filesystemRoots, that.filesystemRoots) && Objects.equals(this.jvmArgs, that.jvmArgs) && this.jvmStartTime == that.jvmStartTime && this.totalPhysicalMemory == that.totalPhysicalMemory && Objects.equals(this.jvmVendor, that.jvmVendor) && Objects.equals(this.osArch, that.osArch) && Objects.equals(this.osVersion, that.osVersion);
    }

    public int hashCode() {
        return Objects.hash(this.systemBootTime, this.macAddress, this.ipAddress, this.processId, this.hostName, this.threadId, this.secureRandomInt, this.counter, this.osName, this.javaVersion, this.userName, this.userDir, this.envVarsHash, this.filesystemRoots, this.jvmArgs, this.cpuCores, this.jvmStartTime, this.totalPhysicalMemory, this.jvmVendor, this.osArch, this.osVersion);
    }

    public String toString() {
        return "EntropySourceContainer{systemBootTime=" + this.systemBootTime + ", macAddress='" + this.macAddress + "', ipAddress='" + this.ipAddress + "', processId='" + this.processId + "', hostName='" + this.hostName + "', threadId=" + this.threadId + ", secureRandomInt=" + this.secureRandomInt + ", counter=" + this.counter + ", osName='" + this.osName + "', javaVersion='" + this.javaVersion + "', userName='" + this.userName + "', userDir='" + this.userDir + "', envVarsHash='" + this.envVarsHash + "', filesystemRoots='" + this.filesystemRoots + "', jvmArgs='" + this.jvmArgs + "', cpuCores=" + this.cpuCores + ", jvmStartTime=" + this.jvmStartTime + ", totalPhysicalMemory=" + this.totalPhysicalMemory + ", jvmVendor='" + this.jvmVendor + "', osArch='" + this.osArch + "', osVersion='" + this.osVersion + "'}";
    }

    public static void main(String[] args) {
        HashSet<EntropySourceContainer> containers = new HashSet<EntropySourceContainer>();
        for (int i = 0; i < 10; ++i) {
            EntropySourceContainer container = new EntropySourceContainer();
            containers.add(container);
            System.out.println("HashCode #" + (i + 1) + ": " + Integer.toHexString(container.hashCode()));
        }
        System.out.println("\nTotal unique hash codes: " + containers.size());
    }
}

