# 薄雾算法（Mist）ID 生成器

薄雾算法是一种高性能的分布式 ID 生成算法，专注于生成唯一、有序且不可预测的 ID。该算法通过巧妙的位运算和随机因子的组合，在保证 ID 唯一性的同时，提供了良好的性能和安全性。

## ID 结构

薄雾算法生成的 ID 由 64 位二进制组成，结构如下：

```
1 2 48 56 64
+------+-----------------------------------------------------+----------+----------+
retain | increas                                             | salt     | sequence |
+------+-----------------------------------------------------+----------+----------+
0      | 0000000000 0000000000 0000000000 0000000 0000000000 | 00000000 | 00000000 |
+------+-----------------------------------------------------+------------+--------+
```

- 最高位（1 位）：保留位，固定为 0，确保生成的 ID 始终为正数
- 自增数（47 位）：在高位进行自增，保证结果值呈递增趋势
- 随机因子一（8 位）：取值范围 0-255，增加 ID 的不可预测性
- 随机因子二（8 位）：取值范围 0-255，进一步增强 ID 的随机性

### 性能特点

- 编号上限为百万亿级：最大值为 140737488355327（(1L << 47) - 1）
- 高性能：假设每天生成 10 亿个 ID，可以使用 385+年
- 有序性：自增数在高位保证了 ID 的整体递增趋势
- 不可预测：通过双重随机因子提高 ID 的安全性

## 实现方式

### 1. 标准实现（StandardMistGenerator）

标准实现采用 AtomicLong 和 ThreadLocalRandom 的组合：

- 使用 AtomicLong 保证自增数的线程安全
- ThreadLocalRandom 提供线程安全的随机数生成
- 适用于一般并发场景

### 2. 安全实现（SecureMistGenerator）

安全实现强化了随机性和线程安全：

- 使用 synchronized 确保线程安全
- 采用 SecureRandom 生成更安全的随机数
- 适用于对安全性要求较高的场景

### 3. 高性能实现（HighPerformanceMistGenerator）

高性能实现专注于提升并发性能：

- 使用静态计数器和位运算提高性能
- ThreadLocalRandom 保证随机数生成的线程安全
- 特别适用于高并发场景
- ID 分布性好，性能卓越

## 使用场景

1. **标准实现**：适用于大多数业务场景，提供了良好的性能和安全性平衡
2. **安全实现**：适用于金融、支付等对安全性要求较高的场景
3. **高性能实现**：适用于高并发系统，如：
   - 大型电商平台的订单 ID 生成
   - 社交媒体的消息 ID 生成
   - 日志系统的事件 ID 生成

## 性能考虑

在选择具体实现时，需要考虑以下因素：

1. **并发量**：

   - 低并发：标准实现或安全实现
   - 高并发：高性能实现

2. **安全需求**：

   - 普通安全：标准实现
   - 高安全：安全实现
   - 性能优先：高性能实现

3. **业务场景**：
   - 需要严格递增：标准实现
   - 需要高安全性：安全实现
   - 需要高并发：高性能实现
