# NanoId 生成器

## 简介

NanoId 是一个小型、安全、URL 友好的唯一字符串 ID 生成器。它生成的 ID 比 UUID 更短（默认 21 个字符），同时保持了足够的随机性和唯一性。NanoId 特别适合在需要生成短小且唯一标识符的 Web 应用中使用。

## 特性

### 1. 短小精悍

- 默认生成 21 个字符的 ID，相比 UUID 的 36 个字符更加简洁
- 占用存储空间更小，更适合作为 URL 参数或数据库主键

### 2. 安全可靠

- 使用`SecureRandom`作为随机数生成器，提供加密级别的安全性
- 保证生成 ID 的随机性和唯一性

### 3. URL 友好

- 使用 URL 安全的字符集，包含：
  - 大小写字母（a-z, A-Z）
  - 数字（0-9）
  - 下划线（\_）和连字符（-）
- 不含特殊字符和易混淆字符
- 可直接用于 URL 而无需编码

### 4. 可定制化

- 支持自定义 ID 长度
- 支持自定义字符集

## 使用示例

### 基本使用

```java
// 创建NanoId生成器实例
NanoIdGenerator generator = new NanoIdGenerator();

// 生成一个NanoId
String id = (String) generator.generate();

// 使用静态方法生成
String id = NanoIdGenerator.next();
```

## 性能优势

### 与 UUID 对比

1. **长度优势**

   - NanoId：21 个字符
   - UUID：36 个字符
   - 节省约 42%的存储空间

2. **URL 友好性**

   - NanoId：直接使用 URL 安全字符，无需编码
   - UUID：包含连字符和字母，可能需要额外编码

3. **随机性**
   - 使用`SecureRandom`保证高质量的随机性
   - 提供足够的唯一性保证

## 适用场景

- Web 应用中的唯一标识符
- URL 短链接服务
- 分布式系统中的资源 ID
- 需要 URL 友好的唯一标识的场景

## 注意事项

1. 默认使用`SecureRandom`作为随机数生成器，提供了更好的随机性，但性能略低于普通的`Random`
2. 21 位的默认长度在大多数场景下提供了足够的唯一性，如需更高的唯一性保证，可以适当增加长度
3. 生成的 ID 是基于随机算法，不保证严格的时序性
