# OrderedUuid 生成器

## 简介

OrderedUuid 生成器是一个专门设计的 UUID 生成工具，它通过将时间戳编码到 UUID 的前字节来实现排序功能。这种设计使得生成的 UUID 既保持了唯一性，又具备了时间顺序性，特别适合在需要按时间排序的分布式系统中使用。

## 特性

- **时间排序性**：通过将时间戳编码到 UUID 的前 6 字节，使 UUID 天然具备时间排序能力
- **全局唯一性**：结合时间戳和随机数据，确保在分布式环境下的唯一性
- **高性能**：生成过程简单高效，无需额外的存储或协调开销
- **兼容性**：完全兼容标准 UUID 格式，可以在任何支持 UUID 的系统中使用

## ID 结构

OrderedUuid 的结构经过精心设计，包含以下部分：

- **前 6 字节**：Unix 时间戳（精确到毫秒）
- **后 10 字节**：随机 UUID 数据

## 使用场景

1. **分布式系统**：在分布式环境下生成可排序的唯一标识符
2. **时序数据**：需要按时间顺序检索和排序的数据存储系统
3. **日志系统**：需要追踪事件发生顺序的日志记录
4. **数据库主键**：作为数据库的主键，提供天然的时间索引能力

## 代码示例

```java
// 生成一个新的OrderedUuid
UUID orderedUuid = OrderedUuidGenerator.next();

// 通过IdGenerator接口使用
IdGenerator generator = new OrderedUuidGenerator();
String id = generator.generate();
```

## 与普通 UUID 对比

| 特性     | OrderedUuid  | 普通 UUID |
| -------- | ------------ | --------- |
| 排序能力 | 支持时间排序 | 无序      |
| 唯一性   | 全局唯一     | 全局唯一  |
| 时间信息 | 包含时间戳   | 不包含    |
| 性能     | 高           | 高        |
| 存储大小 | 16 字节      | 16 字节   |

## 性能考虑

- 生成过程中只涉及简单的位运算，性能开销极小
- 无需网络通信或中心化协调
- 适合高并发场景

## 注意事项

1. 时间戳精度为毫秒级，对于毫秒级内的多个 ID，排序将依赖于随机部分
2. 系统时钟的准确性会影响 ID 的排序准确性
3. 在时钟回拨场景下，仍然能保证 ID 的唯一性，但可能影响排序性
