# Snowflake ID 生成器

## 简介

Snowflake ID 生成器是一个高性能的分布式唯一 ID 生成器实现，基于 Twitter 的 Snowflake 算法。它能够生成趋势递增、全局唯一的 64 位长整型 ID，非常适合分布式系统中使用。

## ID 结构

Snowflake ID 由 64 位二进制数字组成，从高位到低位依次是：

- 1 位符号位：始终为 0，保证 ID 是正数
- 41 位时间戳：精确到毫秒，以 2022-01-01 00:00:00 为基准时间
- 10 位工作节点 ID：支持最多 1024 个节点
- 12 位序列号：同一毫秒内的自增序列，支持每个节点每毫秒产生 4096 个 ID

## 特性

### 1. 全局唯一性

- 通过时间戳、工作节点 ID 和序列号的组合保证全局唯一
- 工作节点 ID 的合理分配确保分布式环境下的唯一性

### 2. 趋势递增

- ID 按时间趋势递增，便于数据库索引优化
- 同一毫秒内的 ID 按序列号递增

### 3. 高性能

- 纯内存操作，无数据库依赖
- 理论上单节点每毫秒可生成 4096 个 ID
- 支持分布式部署，可线性扩展性能

### 4. 安全特性

- 时钟回拨检测和处理
- 序列号溢出处理
- 工作节点 ID 范围检查

## 使用示例

```java
// 创建Snowflake ID生成器实例，需指定工作节点ID（0-1023）
SnowflakeIdGenerator generator = new SnowflakeIdGenerator(1);

// 生成ID
long id = generator.next();

// 通过IdGenerator接口生成ID
Object id = generator.generate();
```

## 注意事项

1. 工作节点 ID（workerId）配置：

   - 取值范围：[0, 1023]
   - 必须确保集群内唯一
   - 建议通过配置中心统一分配

2. 时钟依赖：

   - 服务器时钟不能回退
   - 集群节点间时钟需保持同步
   - 检测到时钟回退时会抛出异常

3. 性能考虑：
   - 单节点理论 QPS = 4096000（4096 \* 1000）
   - 实际 QPS 受服务器性能和网络影响
   - 如需更高性能，可通过增加节点线性扩展

## 对比其他 ID 生成器

| 特性       | Snowflake | UUID | 数据库自增 ID | 号段模式 |
| ---------- | --------- | ---- | ------------- | -------- |
| 有序性     | ✓         | ×    | ✓             | ✓        |
| 唯一性     | ✓         | ✓    | ✓             | ✓        |
| 趋势递增   | ✓         | ×    | ✓             | ✓        |
| 分布式友好 | ✓         | ✓    | ×             | ✓        |
| 性能       | 高        | 高   | 低            | 中       |
| 依赖       | 时钟同步  | 无   | 数据库        | 数据库   |
